/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.types.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.Beta;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.Member;
import org.sonar.plugins.python.api.types.v2.ObjectType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TypeWrapper;
import org.sonar.plugins.python.api.types.v2.UnionType;

@Beta
public final class ClassType
implements PythonType {
    private final String name;
    private final String fullyQualifiedName;
    private final Set<Member> members;
    private final List<PythonType> attributes;
    private final List<TypeWrapper> superClasses;
    private final List<PythonType> metaClasses;
    private final boolean hasDecorators;
    private final boolean isGeneric;
    private final LocationInFile locationInFile;

    public ClassType(String name, String fullyQualifiedName, Set<Member> members, List<PythonType> attributes, List<TypeWrapper> superClasses, List<PythonType> metaClasses, boolean hasDecorators, boolean isGeneric, @Nullable LocationInFile locationInFile) {
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.members = members;
        this.attributes = attributes;
        this.superClasses = superClasses;
        this.metaClasses = metaClasses;
        this.hasDecorators = hasDecorators;
        this.isGeneric = isGeneric;
        this.locationInFile = locationInFile;
    }

    public ClassType(String name, String fullyQualifiedName) {
        this(name, fullyQualifiedName, new HashSet<Member>(), new ArrayList<PythonType>(), new ArrayList<TypeWrapper>(), new ArrayList<PythonType>(), false, false, null);
    }

    @Override
    public Optional<String> displayName() {
        return Optional.of("type");
    }

    @Override
    public Optional<String> instanceDisplayName() {
        String[] splits = this.name.split("\\.");
        if (splits.length > 0) {
            return Optional.of(splits[splits.length - 1]);
        }
        return Optional.of(this.name);
    }

    @Override
    public boolean isCompatibleWith(PythonType another) {
        if (another instanceof ObjectType) {
            ObjectType objectType = (ObjectType)another;
            return this.isCompatibleWith(objectType.type());
        }
        if (another instanceof UnionType) {
            UnionType unionType = (UnionType)another;
            return unionType.candidates().stream().anyMatch(this::isCompatibleWith);
        }
        if (another instanceof FunctionType) {
            FunctionType functionType = (FunctionType)another;
            return this.isCompatibleWith(functionType.returnType());
        }
        if (another instanceof ClassType) {
            ClassType classType = (ClassType)another;
            boolean isASubClass = this.isASubClassFrom(classType);
            boolean areAttributeCompatible = this.areAttributesCompatible(classType);
            boolean isDuckTypeCompatible = !this.members.isEmpty() && this.members.containsAll(classType.members);
            return Objects.equals(this, another) || "builtins.object".equals(classType.name()) || isDuckTypeCompatible || isASubClass && areAttributeCompatible;
        }
        return true;
    }

    @Beta
    public boolean isASubClassFrom(ClassType other) {
        return this.superClasses().stream().anyMatch(superClass -> superClass.type().isCompatibleWith(other));
    }

    @Beta
    public boolean areAttributesCompatible(ClassType other) {
        return this.attributes.stream().allMatch(attr -> other.attributes.stream().anyMatch(attr::isCompatibleWith));
    }

    @Override
    public String key() {
        return Optional.of(this.attributes()).stream().flatMap(Collection::stream).map(PythonType::key).collect(Collectors.joining(",", this.name() + "[", "]"));
    }

    @Override
    public Optional<PythonType> resolveMember(String memberName) {
        return this.resolveMember(memberName, new HashSet<PythonType>());
    }

    private Optional<PythonType> resolveMember(String memberName, Set<PythonType> visited) {
        visited.add(this);
        return this.localMember(memberName).or(() -> this.inheritedMember(memberName, visited));
    }

    private Optional<PythonType> localMember(String memberName) {
        return this.members.stream().filter(m -> m.name().equals(memberName)).map(Member::type).findFirst();
    }

    public Optional<PythonType> inheritedMember(String memberName) {
        return this.inheritedMember(memberName, new HashSet<PythonType>());
    }

    private Optional<PythonType> inheritedMember(String memberName, Set<PythonType> visited) {
        return this.superClasses().stream().map(TypeWrapper::type).filter(Predicate.not(visited::contains)).map(t -> {
            visited.add((PythonType)t);
            if (t instanceof ClassType) {
                ClassType superClassType = (ClassType)t;
                return superClassType.resolveMember(memberName, visited);
            }
            return t.resolveMember(memberName);
        }).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public boolean hasUnresolvedHierarchy() {
        return this.superClasses().stream().anyMatch(s -> {
            PythonType patt5543$temp = s.type();
            if (patt5543$temp instanceof ClassType) {
                ClassType parentClassType = (ClassType)patt5543$temp;
                return parentClassType.hasUnresolvedHierarchy();
            }
            return true;
        });
    }

    @Override
    public TriBool hasMember(String memberName) {
        if ("__call__".equals(memberName)) {
            return TriBool.TRUE;
        }
        if (this.resolveMember(memberName).filter(t -> t != PythonType.UNKNOWN).isPresent()) {
            return TriBool.TRUE;
        }
        if (this.hasUnresolvedHierarchy()) {
            return TriBool.UNKNOWN;
        }
        return TriBool.UNKNOWN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasMetaClass() {
        if (!this.metaClasses.isEmpty()) return true;
        if (!this.superClasses().stream().map(TypeWrapper::type).filter(ClassType.class::isInstance).map(ClassType.class::cast).anyMatch(ClassType::hasMetaClass)) return false;
        return true;
    }

    public TriBool instancesHaveMember(String memberName) {
        if (this.hasUnresolvedHierarchy() || this.hasMetaClass() || this.hasDecorators()) {
            return TriBool.UNKNOWN;
        }
        if ("NamedTuple".equals(this.name)) {
            return TriBool.TRUE;
        }
        if ("function".equals(this.name) && "__call__".equals(memberName)) {
            return TriBool.TRUE;
        }
        return this.resolveMember(memberName).isPresent() ? TriBool.TRUE : TriBool.FALSE;
    }

    @Override
    public Optional<LocationInFile> definitionLocation() {
        return Optional.ofNullable(this.locationInFile);
    }

    public String toString() {
        return "ClassType[%s]".formatted(this.name);
    }

    @Override
    public String name() {
        return this.name;
    }

    public String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public Set<Member> members() {
        return this.members;
    }

    public List<PythonType> attributes() {
        return this.attributes;
    }

    public List<TypeWrapper> superClasses() {
        return this.superClasses;
    }

    public List<PythonType> metaClasses() {
        return this.metaClasses;
    }

    public boolean hasDecorators() {
        return this.hasDecorators;
    }

    public boolean isGeneric() {
        return this.isGeneric;
    }
}

