/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.nosonar;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.plugins.python.api.nosonar.NoSonarLineInfo;

public class NoSonarInfoParser {
    private static final Integer MAX_COMMENT_LENGTH = 50;
    private static final String NOQA_PREFIX_REGEX = "#\\s*noqa([\\s:].*)?";
    private static final String NOQA_PATTERN_REGEX = "^#\\s*noqa(?::\\s*(.+))?(?:[\\s;:].*)?";
    private static final String NOSONAR_PREFIX_REGEX = "^#\\s*NOSONAR(\\W.*)?";
    private static final String NOSONAR_PATTERN_REGEX = "^#\\s*NOSONAR(?:\\s*\\(([^)]*)\\))?($|\\s.*)";
    private static final String RULE_KEY_PATTERN_REGEX = "^[a-zA-Z0-9]+$";
    private final Pattern noSonarPattern = Pattern.compile("^#\\s*NOSONAR(?:\\s*\\(([^)]*)\\))?($|\\s.*)");
    private final Pattern noQaPattern = Pattern.compile("^#\\s*noqa(?::\\s*(.+))?(?:[\\s;:].*)?");

    public boolean isInvalidIssueSuppressionComment(String commentsLine) {
        return NoSonarInfoParser.splitInlineComments(commentsLine).stream().anyMatch(comment -> this.isInvalidNoSonarComment((String)comment) || this.isInvalidNoQaComment((String)comment));
    }

    private boolean isInvalidNoSonarComment(String comment) {
        if (NoSonarInfoParser.isNoSonarWithoutPound(comment)) {
            return true;
        }
        if (!Pattern.matches(NOSONAR_PREFIX_REGEX, comment)) {
            return false;
        }
        if (!NoSonarInfoParser.isValidNoSonar(comment)) {
            return true;
        }
        List<String> rules = this.parseNoSonarRules(comment).toList();
        return !rules.isEmpty() && rules.stream().anyMatch(NoSonarInfoParser::isInvalidRuleKey);
    }

    private static boolean isNoSonarWithoutPound(String comment) {
        return NoSonarInfoParser.countOccurrences("#\\s*NOSONAR", comment) < NoSonarInfoParser.countOccurrences("NOSONAR", comment);
    }

    private static boolean isInvalidRuleKey(String ruleKey) {
        return !ruleKey.matches(RULE_KEY_PATTERN_REGEX);
    }

    private static int countOccurrences(String match, String inString) {
        return inString.split(match, -1).length - 1;
    }

    private boolean isInvalidNoQaComment(String comment) {
        if (!comment.matches(NOQA_PREFIX_REGEX)) {
            return false;
        }
        if (!NoSonarInfoParser.isValidNoQa(comment)) {
            return true;
        }
        List<String> rules = this.parseNoQaRules(comment);
        return !rules.isEmpty() && rules.stream().anyMatch(r -> r.isBlank() || r.contains(" "));
    }

    private static boolean isValidNoSonar(String noSonarCommentLine) {
        return noSonarCommentLine.matches(NOSONAR_PATTERN_REGEX);
    }

    public static boolean isValidNoQa(String noSonarCommentLine) {
        return noSonarCommentLine.matches(NOQA_PATTERN_REGEX);
    }

    public Optional<NoSonarLineInfo> parse(String commentLine) {
        HashSet<String> rules = new HashSet<String>();
        StringBuilder concatenatedCommentBuilder = new StringBuilder();
        List<String> comments = NoSonarInfoParser.splitInlineComments(commentLine);
        for (String comment : comments) {
            NoSonarLineInfo noSonarLineInfo = this.parseComment(comment);
            if (noSonarLineInfo != null) {
                if (noSonarLineInfo.isSuppressedRuleKeysEmpty()) {
                    return Optional.of(noSonarLineInfo);
                }
                rules.addAll(noSonarLineInfo.suppressedRuleKeys());
                concatenatedCommentBuilder.append(noSonarLineInfo.comment());
                continue;
            }
            concatenatedCommentBuilder.append(comment.strip());
        }
        if (rules.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new NoSonarLineInfo(rules, concatenatedCommentBuilder.toString()));
    }

    @CheckForNull
    private NoSonarLineInfo parseComment(String commentLine) {
        HashSet<String> rules = new HashSet<String>();
        String comment = "";
        if (NoSonarInfoParser.isValidNoSonar(commentLine)) {
            this.parseNoSonarRules(commentLine).filter(Predicate.not(String::isEmpty)).forEach(rules::add);
            comment = this.parseNoSonarComment(commentLine);
        } else if (NoSonarInfoParser.isValidNoQa(commentLine)) {
            this.parseNoQaRules(commentLine).stream().filter(Predicate.not(String::isEmpty)).forEach(rules::add);
            comment = this.parseNoQaComment(commentLine);
        } else {
            return null;
        }
        return new NoSonarLineInfo(rules, comment);
    }

    private static List<String> splitInlineComments(String commentsLine) {
        return Stream.of(commentsLine.split("#")).filter(Predicate.not(String::isBlank)).map(s -> "#" + s).toList();
    }

    private Stream<String> parseNoSonarRules(String noSonarCommentLine) {
        String contentInsideParentheses = NoSonarInfoParser.getParamsString(this.noSonarPattern, noSonarCommentLine);
        return NoSonarInfoParser.parseParamsString(contentInsideParentheses);
    }

    private String parseNoSonarComment(String noSonarCommentLine) {
        return NoSonarInfoParser.getTruncatedCommentString(this.noSonarPattern, noSonarCommentLine).strip();
    }

    private List<String> parseNoQaRules(String noSonarCommentLine) {
        String paramsString = NoSonarInfoParser.getParamsString(this.noQaPattern, noSonarCommentLine);
        List<String> paramsList = NoSonarInfoParser.parseParamsString(paramsString).collect(Collectors.toList());
        if (!paramsList.isEmpty()) {
            int lastParamIndex = paramsList.size() - 1;
            String lastParamRaw = paramsList.get(lastParamIndex);
            String lastParam = lastParamRaw.split("(:?\\s)", 0)[0].trim();
            paramsList.set(lastParamIndex, lastParam);
        }
        return paramsList;
    }

    private String parseNoQaComment(String noSonarCommentLine) {
        return NoSonarInfoParser.getTruncatedCommentString(this.noQaPattern, noSonarCommentLine).strip();
    }

    private static String getParamsString(Pattern pattern, String noSonarCommentLine) {
        return NoSonarInfoParser.getPatternGroup(1, pattern, noSonarCommentLine);
    }

    private static String getTruncatedCommentString(Pattern pattern, String noSonarCommentLine) {
        String commentString = NoSonarInfoParser.getPatternGroup(2, pattern, noSonarCommentLine);
        return commentString.length() > MAX_COMMENT_LENGTH ? commentString.substring(0, MAX_COMMENT_LENGTH) : commentString;
    }

    private static String getPatternGroup(int groupIndex, Pattern pattern, String noSonarCommentLine) {
        return Optional.of(noSonarCommentLine).map(pattern::matcher).filter(Matcher::matches).filter(m -> m.groupCount() >= groupIndex).map(m -> m.group(groupIndex)).orElse("");
    }

    private static Stream<String> parseParamsString(String paramsString) {
        if (paramsString.isBlank()) {
            return Stream.of(new String[0]);
        }
        String[] paramsArray = paramsString.split(",", -1);
        return Stream.of(paramsArray).map(String::trim);
    }
}

