/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import org.sonar.plugins.python.api.tree.Token;

public class TokenLocation {
    private final int startLine;
    private final int startLineOffset;
    private final int endLine;
    private final int endLineOffset;

    public TokenLocation(Token token) {
        this.startLine = token.line();
        this.startLineOffset = token.column();
        String value = token.value();
        String[] lines = value.split("\r\n|\n|\r", -1);
        if (lines.length > 1) {
            if (token.isCompressed()) {
                this.endLine = token.line();
                this.endLineOffset = this.startLineOffset + token.valueLength();
            } else {
                this.endLine = token.line() + lines.length - 1;
                this.endLineOffset = lines[lines.length - 1].length();
            }
        } else {
            this.endLine = this.startLine;
            this.endLineOffset = this.startLineOffset + token.valueLength();
        }
    }

    public int startLine() {
        return this.startLine;
    }

    public int startLineOffset() {
        return this.startLineOffset;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endLineOffset() {
        return this.endLineOffset;
    }
}

