/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.Beta;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
@Beta
public class SonarLintCache
implements ReadCache,
WriteCache {
    private final Map<String, byte[]> cache = new HashMap<String, byte[]>();

    public InputStream read(String s) {
        if (!this.contains(s)) {
            throw new IllegalArgumentException(String.format("SonarLintCache does not contain key \"%s\"", s));
        }
        return new ByteArrayInputStream(this.cache.get(s));
    }

    public boolean contains(String s) {
        return this.cache.containsKey(s);
    }

    public void write(String s, InputStream inputStream) {
        try {
            this.write(s, inputStream.readAllBytes());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(String s, byte[] bytes) {
        if (this.contains(s)) {
            throw new IllegalArgumentException(String.format("Same key cannot be written to multiple times (%s)", s));
        }
        this.cache.put(s, bytes);
    }

    public void copyFromPrevious(String s) {
        throw new UnsupportedOperationException("SonarLintCache does not allow to copy from previous.");
    }
}

