/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import com.google.common.annotations.Beta;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonInputFileContext;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.types.v2.ModuleType;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.semantic.v2.SymbolTable;
import org.sonar.python.semantic.v2.SymbolTableBuilderV2;
import org.sonar.python.semantic.v2.TypeInferenceV2;
import org.sonar.python.semantic.v2.callgraph.CallGraph;
import org.sonar.python.semantic.v2.callgraph.CallGraphCollector;
import org.sonar.python.semantic.v2.typetable.ProjectLevelTypeTable;
import org.sonar.python.semantic.v2.typetable.TypeTable;
import org.sonar.python.types.v2.TypeChecker;

public class PythonVisitorContext
extends PythonInputFileContext {
    private final FileInput rootTree;
    private final RecognitionException parsingException;
    private final TypeChecker typeChecker;
    private final ModuleType moduleType;
    private final List<PythonCheck.PreciseIssue> issues;
    private final ProjectConfiguration projectConfiguration;
    private final CallGraph callGraph;
    private final TypeTable typeTable;

    private PythonVisitorContext(FileInput rootTree, PythonFile pythonFile, @Nullable File workingDirectory, ProjectLevelSymbolTable projectLevelSymbolTable, CacheContext cacheContext, SonarProduct sonarProduct, ProjectConfiguration projectConfiguration, ModuleType moduleType, CallGraph callGraph, TypeTable typeTable) {
        super(pythonFile, workingDirectory, cacheContext, sonarProduct, projectLevelSymbolTable);
        this.moduleType = moduleType;
        this.projectConfiguration = projectConfiguration;
        this.callGraph = callGraph;
        this.rootTree = rootTree;
        this.parsingException = null;
        this.typeTable = typeTable;
        this.typeChecker = new TypeChecker(typeTable);
        this.issues = new ArrayList<PythonCheck.PreciseIssue>();
    }

    public PythonVisitorContext(PythonFile pythonFile, RecognitionException parsingException, SonarProduct sonarProduct) {
        super(pythonFile, null, CacheContextImpl.dummyCache(), sonarProduct, ProjectLevelSymbolTable.empty());
        this.rootTree = null;
        this.parsingException = parsingException;
        this.typeTable = new ProjectLevelTypeTable(ProjectLevelSymbolTable.empty());
        this.typeChecker = new TypeChecker(this.typeTable);
        this.projectConfiguration = new ProjectConfiguration();
        this.callGraph = CallGraph.EMPTY;
        this.issues = new ArrayList<PythonCheck.PreciseIssue>();
        this.moduleType = null;
    }

    public FileInput rootTree() {
        return this.rootTree;
    }

    public TypeChecker typeChecker() {
        return this.typeChecker;
    }

    public TypeTable typeTable() {
        return this.typeTable;
    }

    public RecognitionException parsingException() {
        return this.parsingException;
    }

    public void addIssue(PythonCheck.PreciseIssue issue) {
        this.issues.add(issue);
    }

    public List<PythonCheck.PreciseIssue> getIssues() {
        return this.issues;
    }

    @CheckForNull
    @Beta
    public ModuleType moduleType() {
        return this.moduleType;
    }

    public ProjectConfiguration projectConfiguration() {
        return this.projectConfiguration;
    }

    public CallGraph callGraph() {
        return this.callGraph;
    }

    public static class Builder {
        private final PythonFile pythonFile;
        private final FileInput rootTree;
        private Optional<ProjectLevelSymbolTable> projectLevelSymbolTable = Optional.empty();
        private Optional<TypeTable> typeTable = Optional.empty();
        private Optional<CacheContext> cacheContext = Optional.empty();
        private Optional<SonarProduct> sonarProduct = Optional.empty();
        private Optional<File> workingDirectory = Optional.empty();
        private Optional<ProjectConfiguration> projectConfiguration = Optional.empty();
        private Optional<CallGraph> callGraph = Optional.empty();
        private Optional<String> packageName = Optional.empty();
        private Optional<ModuleType> moduleType = Optional.empty();

        public Builder(FileInput rootTree, PythonFile pythonFile) {
            this.rootTree = rootTree;
            this.pythonFile = pythonFile;
        }

        public Builder workingDirectory(@Nullable File workingDirectory) {
            this.workingDirectory = Optional.ofNullable(workingDirectory);
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = Optional.of(packageName);
            return this;
        }

        public Builder projectLevelSymbolTable(ProjectLevelSymbolTable projectLevelSymbolTable) {
            this.projectLevelSymbolTable = Optional.of(projectLevelSymbolTable);
            return this;
        }

        public Builder typeTable(TypeTable typeTable) {
            this.typeTable = Optional.of(typeTable);
            return this;
        }

        public Builder cacheContext(CacheContext cacheContext) {
            this.cacheContext = Optional.of(cacheContext);
            return this;
        }

        public Builder sonarProduct(SonarProduct sonarProduct) {
            this.sonarProduct = Optional.of(sonarProduct);
            return this;
        }

        public Builder projectConfiguration(ProjectConfiguration projectConfiguration) {
            this.projectConfiguration = Optional.of(projectConfiguration);
            return this;
        }

        public Builder moduleType(ModuleType moduleType) {
            this.moduleType = Optional.of(moduleType);
            return this;
        }

        public Builder callGraph(CallGraph callGraph) {
            this.callGraph = Optional.of(callGraph);
            return this;
        }

        public PythonVisitorContext build() {
            ProjectLevelSymbolTable symbolTable = this.projectLevelSymbolTable.orElseGet(ProjectLevelSymbolTable::empty);
            String pkgName = this.packageName.orElse("");
            Builder.buildSymbols(this.rootTree, this.pythonFile, pkgName, symbolTable);
            TypeTable finalTypeTable = this.typeTable.orElseGet(() -> new ProjectLevelTypeTable(symbolTable));
            ModuleType mt = this.moduleType.orElseGet(() -> {
                SymbolTableBuilderV2 symbolTableBuilderV2 = new SymbolTableBuilderV2(this.rootTree);
                SymbolTable symbolTableV2 = symbolTableBuilderV2.build();
                return new TypeInferenceV2(finalTypeTable, this.pythonFile, symbolTableV2, pkgName).inferModuleType(this.rootTree);
            });
            CallGraph finalCallGraph = this.callGraph.orElseGet(() -> CallGraphCollector.collectCallGraph(this.rootTree));
            return new PythonVisitorContext(this.rootTree, this.pythonFile, this.workingDirectory.orElse(null), symbolTable, this.cacheContext.orElseGet(CacheContextImpl::dummyCache), this.sonarProduct.orElse(SonarProduct.SONARQUBE), this.projectConfiguration.orElse(new ProjectConfiguration()), mt, finalCallGraph, finalTypeTable);
        }

        private static synchronized void buildSymbols(FileInput rootTree, PythonFile pythonFile, String packageName, ProjectLevelSymbolTable projectLevelSymbolTable) {
            SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile, projectLevelSymbolTable);
            symbolTableBuilder.visitFileInput(rootTree);
        }
    }
}

