/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonVersionUtils {
    private static final Version MIN_SUPPORTED_VERSION = Version.V_38;
    public static final Version MAX_SUPPORTED_VERSION = Version.V_314;
    private static final Map<String, Version> STRING_VERSION_MAP = Map.ofEntries(Map.entry("3.0", MIN_SUPPORTED_VERSION), Map.entry("3.1", MIN_SUPPORTED_VERSION), Map.entry("3.2", MIN_SUPPORTED_VERSION), Map.entry("3.3", MIN_SUPPORTED_VERSION), Map.entry("3.4", MIN_SUPPORTED_VERSION), Map.entry("3.5", MIN_SUPPORTED_VERSION), Map.entry("3.6", MIN_SUPPORTED_VERSION), Map.entry("3.7", MIN_SUPPORTED_VERSION), Map.entry("3.8", Version.V_38), Map.entry("3.9", Version.V_39), Map.entry("3.10", Version.V_310), Map.entry("3.11", Version.V_311), Map.entry("3.12", Version.V_312), Map.entry("3.13", Version.V_313), Map.entry("3.14", Version.V_314));
    private static final Logger LOG = LoggerFactory.getLogger(PythonVersionUtils.class);
    public static final String PYTHON_VERSION_KEY = "sonar.python.version";

    private PythonVersionUtils() {
    }

    public static Set<Version> fromString(String propertyValue) {
        return PythonVersionUtils.fromStringArray(propertyValue.split(","));
    }

    public static Set<Version> fromStringArray(String[] versions) {
        if (versions.length == 0) {
            return PythonVersionUtils.allVersions();
        }
        EnumSet<Version> pythonVersions = EnumSet.noneOf(Version.class);
        for (String versionValue : versions) {
            if ("3".equals(versionValue = versionValue.trim())) {
                return PythonVersionUtils.allVersions();
            }
            Version version = STRING_VERSION_MAP.get(versionValue);
            if (version != null) {
                pythonVersions.add(version);
                continue;
            }
            boolean isGuessSuccessful = PythonVersionUtils.guessPythonVersion(pythonVersions, versionValue);
            if (isGuessSuccessful) continue;
            return PythonVersionUtils.allVersions();
        }
        return pythonVersions;
    }

    public static Set<Version> allVersions() {
        return EnumSet.allOf(Version.class);
    }

    private static boolean guessPythonVersion(Set<Version> pythonVersions, String versionValue) {
        block6: {
            String[] version = versionValue.split("\\.");
            try {
                int major = Integer.parseInt(version[0]);
                int minor = version.length > 1 ? Integer.parseInt(version[1]) : 0;
                Version guessedVersion = STRING_VERSION_MAP.get(major + "." + minor);
                if (guessedVersion != null) {
                    pythonVersions.add(guessedVersion);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, guessedVersion);
                    return true;
                }
                if (major < 3) {
                    PythonVersionUtils.logWarningPython2(versionValue);
                    return false;
                }
                if (MIN_SUPPORTED_VERSION.compare(major, minor) > 0) {
                    pythonVersions.add(MIN_SUPPORTED_VERSION);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, MIN_SUPPORTED_VERSION);
                    break block6;
                }
                if (MAX_SUPPORTED_VERSION.compare(major, minor) < 0) {
                    pythonVersions.add(MAX_SUPPORTED_VERSION);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, MAX_SUPPORTED_VERSION);
                    break block6;
                }
                PythonVersionUtils.logErrorMessage(versionValue);
                return false;
            }
            catch (NumberFormatException nfe) {
                PythonVersionUtils.logErrorMessage(versionValue);
                return false;
            }
        }
        return true;
    }

    public static boolean areSourcePythonVersionsGreaterOrEqualThan(Set<Version> sourcePythonVersions, Version required) {
        return !sourcePythonVersions.isEmpty() && sourcePythonVersions.stream().allMatch(version -> version.compare(required.major(), required.minor()) >= 0);
    }

    private static void logErrorMessage(String propertyValue) {
        LOG.warn("Error while parsing value of parameter '{}' ({}). Versions must be specified as MAJOR_VERSION.MINOR_VERSION (e.g. \"3.7, 3.8\")", (Object)PYTHON_VERSION_KEY, (Object)propertyValue);
    }

    private static void logWarningGuessVersion(String propertyValue, Version guessedVersion) {
        LOG.warn("No explicit support for version {}. Python version has been set to {}.", (Object)propertyValue, (Object)guessedVersion);
    }

    private static void logWarningPython2(String propertyValue) {
        LOG.warn("No explicit support for version {}. Support for Python versions prior to 3 is deprecated.", (Object)propertyValue);
    }

    public static enum Version {
        V_38(3, 8, "38"),
        V_39(3, 9, "39"),
        V_310(3, 10, "310"),
        V_311(3, 11, "311"),
        V_312(3, 12, "312"),
        V_313(3, 13, "313"),
        V_314(3, 14, "314");

        private final int major;
        private final int minor;
        private final String serializedValue;

        private Version(int major, int minor, String serializedValue) {
            this.major = major;
            this.minor = minor;
            this.serializedValue = serializedValue;
        }

        public int major() {
            return this.major;
        }

        public int minor() {
            return this.minor;
        }

        public String serializedValue() {
            return this.serializedValue;
        }

        public int compare(int major, int minor) {
            if (this.major() == major) {
                return Integer.compare(this.minor(), minor);
            }
            return Integer.compare(this.major(), major);
        }

        public String toString() {
            return this.major + "." + this.minor;
        }
    }
}

