/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import java.nio.file.Path;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.GeneratedIPythonFile;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.TokenLocation;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.IPythonLocation;
import org.sonar.python.semantic.SymbolUtils;

public abstract class IssueLocation {
    public static final int UNDEFINED_OFFSET = -1;
    public static final int UNDEFINED_LINE = 0;
    private final String message;

    private IssueLocation(@Nullable String message) {
        this.message = message;
    }

    public static IssueLocation atFileLevel(String message) {
        return new FileLevelIssueLocation(message);
    }

    public static IssueLocation atLineLevel(String message, int lineNumber, PythonFile pythonInputFile) {
        if (pythonInputFile instanceof SonarQubePythonFile.IpynbFile) {
            LocationInFile locationInFile;
            String fileId;
            SonarQubePythonFile.IpynbFile ipynbFile = (SonarQubePythonFile.IpynbFile)pythonInputFile;
            GeneratedIPythonFile generatedPythonFile = ipynbFile.pythonInputFile();
            Map<Integer, IPythonLocation> mapping = generatedPythonFile.locationMap();
            IPythonLocation begin = mapping.get(lineNumber);
            Path path = SymbolUtils.pathOf(ipynbFile);
            String string = fileId = path != null ? path.toString() : ipynbFile.toString();
            if (begin.isCompresssed()) {
                IPythonLocation next = mapping.get(lineNumber + 1);
                if (next == null) {
                    throw new IllegalStateException("No mapping for line " + (lineNumber + 1) + " in " + ipynbFile);
                }
                locationInFile = new LocationInFile(fileId, begin.line(), begin.column(), next.line(), next.column());
            } else {
                locationInFile = new LocationInFile(fileId, begin.line(), -1, begin.line(), -1);
            }
            return new PreciseIssueLocation(locationInFile, message);
        }
        return new LineLevelIssueLocation(message, lineNumber);
    }

    public static IssueLocation preciseLocation(Tree tree, @Nullable String message) {
        return new PreciseIssueLocation(tree.firstToken(), tree.lastToken(), message);
    }

    public static IssueLocation preciseLocation(Token token, @Nullable String message) {
        return new PreciseIssueLocation(token, message);
    }

    public static IssueLocation preciseLocation(Token from, Token to, @Nullable String message) {
        return new PreciseIssueLocation(from, to, message);
    }

    public static IssueLocation preciseLocation(LocationInFile locationInFile, @Nullable String message) {
        return new PreciseIssueLocation(locationInFile, message);
    }

    @CheckForNull
    public String message() {
        return this.message;
    }

    public abstract int startLine();

    public abstract int startLineOffset();

    public abstract int endLine();

    public abstract int endLineOffset();

    @CheckForNull
    public abstract String fileId();

    private static class FileLevelIssueLocation
    extends IssueLocation {
        public FileLevelIssueLocation(String message) {
            super(message);
        }

        @Override
        public int startLine() {
            return 0;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return 0;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }

        @Override
        public String fileId() {
            return null;
        }
    }

    private static class PreciseIssueLocation
    extends IssueLocation {
        @CheckForNull
        private final String fileId;
        private final int startLine;
        private final int startLineOffset;
        private final int endLine;
        private final int endLineOffset;

        public PreciseIssueLocation(Token firstToken, Token lastToken, @Nullable String message) {
            super(message);
            this.startLine = firstToken.line();
            this.startLineOffset = firstToken.column();
            TokenLocation tokenLocation = new TokenLocation(lastToken);
            this.endLine = tokenLocation.endLine();
            this.endLineOffset = tokenLocation.endLineOffset();
            this.fileId = null;
        }

        public PreciseIssueLocation(Token token, @Nullable String message) {
            this(token, token, message);
        }

        public PreciseIssueLocation(LocationInFile locationInFile, @Nullable String message) {
            super(message);
            this.startLine = locationInFile.startLine();
            this.startLineOffset = locationInFile.startLineOffset();
            this.endLine = locationInFile.endLine();
            this.endLineOffset = locationInFile.endLineOffset();
            this.fileId = locationInFile.fileId();
        }

        @Override
        public int startLine() {
            return this.startLine;
        }

        @Override
        public int startLineOffset() {
            return this.startLineOffset;
        }

        @Override
        public int endLine() {
            return this.endLine;
        }

        @Override
        public int endLineOffset() {
            return this.endLineOffset;
        }

        @Override
        public String fileId() {
            return this.fileId;
        }
    }

    private static class LineLevelIssueLocation
    extends IssueLocation {
        private final int lineNumber;

        public LineLevelIssueLocation(String message, int lineNumber) {
            super(message);
            this.lineNumber = lineNumber;
        }

        @Override
        public int startLine() {
            return this.lineNumber;
        }

        @Override
        public int startLineOffset() {
            return -1;
        }

        @Override
        public int endLine() {
            return this.lineNumber;
        }

        @Override
        public int endLineOffset() {
            return -1;
        }

        @Override
        public String fileId() {
            return null;
        }
    }
}

