/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.IOException;
import java.net.URI;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.python.GeneratedIPythonFile;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.api.PythonFile;

public abstract class SonarQubePythonFile
implements PythonFile {
    private final InputFile inputFile;

    private SonarQubePythonFile(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    public static PythonFile create(InputFile inputFile) {
        return new Sq62File(inputFile);
    }

    public static PythonFile create(PythonInputFile pythonInputFile) {
        if (pythonInputFile.kind() == PythonInputFile.Kind.PYTHON) {
            return new Sq62File(pythonInputFile.wrappedFile());
        }
        return new IpynbFile((GeneratedIPythonFile)pythonInputFile);
    }

    @Override
    public String fileName() {
        return this.inputFile.filename();
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public URI uri() {
        return this.inputFile().uri();
    }

    @Override
    public String key() {
        return this.inputFile().key();
    }

    public String toString() {
        return this.inputFile.toString();
    }

    private static class Sq62File
    extends SonarQubePythonFile {
        public Sq62File(InputFile inputFile) {
            super(inputFile);
        }

        @Override
        public String content() {
            try {
                return this.inputFile().contents();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read content of input file " + this.inputFile(), e);
            }
        }
    }

    public static class IpynbFile
    extends SonarQubePythonFile {
        private final GeneratedIPythonFile pythonInputFile;

        private IpynbFile(GeneratedIPythonFile inputFile) {
            super(inputFile.wrappedFile());
            this.pythonInputFile = inputFile;
        }

        @Override
        public String content() {
            try {
                return this.pythonInputFile().contents();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read content of input file " + this.inputFile(), e);
            }
        }

        public GeneratedIPythonFile pythonInputFile() {
            return this.pythonInputFile;
        }
    }
}

