/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.python.GeneratedIPythonFile;
import org.sonar.plugins.python.IssuesRepository;
import org.sonar.plugins.python.MeasuresRepository;
import org.sonar.plugins.python.NewSymbolsCollector;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonFileConsumer;
import org.sonar.plugins.python.api.PythonInputFileContext;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.internal.EndOfAnalysis;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.cpd.PythonCpdAnalyzer;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.plugins.python.nosonar.NoSonarLineInfoCollector;
import org.sonar.python.IPythonLocation;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.tree.IPythonTreeMaker;
import org.sonar.python.tree.PythonTreeMaker;

public class PythonScanner
extends Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(PythonScanner.class);
    private static final Pattern DATABRICKS_MAGIC_COMMAND_PATTERN = Pattern.compile("^\\h*#\\h*(MAGIC|COMMAND).*");
    private static final String ARCHITECTURE_CALLBACK_LOCK_KEY = "architectureCallbackLock";
    private final Supplier<PythonParser> parserSupplier;
    private final PythonChecks checks;
    private final PythonCpdAnalyzer cpdAnalyzer;
    private final PythonIndexer indexer;
    private final Map<PythonInputFile, Set<Class<? extends PythonCheck>>> checksExecutedWithoutParsingByFiles;
    private final AtomicInteger recognitionErrorCount;
    private final AtomicBoolean foundDatabricks;
    private final PythonFileConsumer architectureCallback;
    private final Map<String, Lock> repositoryLocks;
    private final NewSymbolsCollector newSymbolsCollector;
    private final PythonHighlighter pythonHighlighter;
    private final IssuesRepository issuesRepository;
    private final MeasuresRepository measuresRepository;
    private final NoSonarLineInfoCollector noSonarLineInfoCollector;
    private final Lock lock;

    public PythonScanner(SensorContext context, PythonChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Supplier<PythonParser> parserSupplier, PythonIndexer indexer, PythonFileConsumer architectureCallback, NoSonarLineInfoCollector noSonarLineInfoCollector) {
        super(context);
        this.checks = checks;
        this.parserSupplier = parserSupplier;
        this.indexer = indexer;
        this.noSonarLineInfoCollector = noSonarLineInfoCollector;
        this.indexer.buildOnce(context);
        this.architectureCallback = architectureCallback;
        this.checksExecutedWithoutParsingByFiles = new ConcurrentHashMap<PythonInputFile, Set<Class<? extends PythonCheck>>>();
        this.recognitionErrorCount = new AtomicInteger(0);
        this.foundDatabricks = new AtomicBoolean(false);
        this.repositoryLocks = new ConcurrentHashMap<String, Lock>();
        this.lock = new ReentrantLock();
        this.cpdAnalyzer = new PythonCpdAnalyzer(context, this.lock);
        this.newSymbolsCollector = new NewSymbolsCollector(this.lock);
        this.pythonHighlighter = new PythonHighlighter(this.lock);
        this.issuesRepository = new IssuesRepository(context, checks, indexer, PythonScanner.isInSonarLint(context), this.lock);
        this.measuresRepository = new MeasuresRepository(context, noSonarFilter, fileLinesContextFactory, PythonScanner.isInSonarLint(context), noSonarLineInfoCollector, this.lock);
    }

    @Override
    protected String name() {
        return "rules execution";
    }

    @Override
    protected void logStart(int numThreads) {
        LOG.debug("Scanning files in {} threads", (Object)numThreads);
    }

    @Override
    protected void scanFile(PythonInputFile inputFile) throws IOException {
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
        InputFile.Type fileType = inputFile.wrappedFile().type();
        PythonVisitorContext visitorContext = this.createVisitorContext(inputFile, pythonFile);
        this.executeChecks(visitorContext, this.checks.sonarPythonChecks(), fileType, inputFile);
        this.executeOtherChecks(inputFile, visitorContext, fileType);
        this.runLockedByRepository(ARCHITECTURE_CALLBACK_LOCK_KEY, () -> this.architectureCallback.scanFile(visitorContext));
        this.noSonarLineInfoCollector.collect(pythonFile.key(), visitorContext.rootTree());
        if (fileType == InputFile.Type.MAIN && visitorContext.rootTree() != null) {
            this.pushTokens(inputFile, visitorContext);
            this.measuresRepository.save(inputFile, visitorContext);
        }
        List<PythonCheck.PreciseIssue> issues = visitorContext.getIssues();
        this.issuesRepository.save(inputFile, issues);
        if (visitorContext.rootTree() != null && !PythonScanner.isInSonarLint(this.context)) {
            this.newSymbolsCollector.collect(this.context.newSymbolTable().onFile(inputFile.wrappedFile()), visitorContext.rootTree());
            this.pythonHighlighter.highlight(this.context, visitorContext, inputFile);
        }
        this.searchForDataBricks(visitorContext);
    }

    private PythonVisitorContext createVisitorContext(PythonInputFile inputFile, PythonFile pythonFile) throws IOException {
        PythonVisitorContext visitorContext;
        try {
            AstNode astNode = this.parserSupplier.get().parse(inputFile.contents());
            PythonTreeMaker treeMaker = PythonScanner.getTreeMaker(inputFile);
            FileInput parse = treeMaker.fileInput(astNode);
            visitorContext = new PythonVisitorContext.Builder(parse, pythonFile).projectConfiguration(this.indexer.projectConfig()).workingDirectory(PythonScanner.getWorkingDirectory(this.context)).packageName(this.indexer.packageName(inputFile)).projectLevelSymbolTable(this.indexer.projectLevelSymbolTable()).typeTable(this.indexer.projectLevelTypeTable()).cacheContext(this.indexer.cacheContext()).sonarProduct(this.context.runtime().getProduct()).build();
        }
        catch (RecognitionException e) {
            visitorContext = new PythonVisitorContext(pythonFile, e, this.context.runtime().getProduct());
            int line = inputFile.kind() == PythonInputFile.Kind.IPYTHON ? ((GeneratedIPythonFile)inputFile).locationMap().get(e.getLine()).line() : e.getLine();
            String newMessage = e.getMessage().replace("line " + e.getLine(), "line " + line);
            LOG.error("Unable to parse file: {}", (Object)inputFile);
            LOG.error(newMessage);
            this.recognitionErrorCount.incrementAndGet();
            this.context.newAnalysisError().onFile(inputFile.wrappedFile()).at(inputFile.wrappedFile().newPointer(line, 0)).message(newMessage).save();
        }
        return visitorContext;
    }

    private void pushTokens(PythonInputFile inputFile, PythonVisitorContext visitorContext) {
        if (!PythonScanner.isInSonarLint(this.context) && inputFile.kind() == PythonInputFile.Kind.PYTHON) {
            this.cpdAnalyzer.pushCpdTokens(inputFile.wrappedFile(), visitorContext);
        }
    }

    private void executeChecks(PythonVisitorContext visitorContext, Collection<PythonCheck> checks, InputFile.Type fileType, PythonInputFile inputFile) {
        ArrayList<PythonSubscriptionCheck> subscriptionChecks = new ArrayList<PythonSubscriptionCheck>();
        for (PythonCheck check : checks) {
            if (this.isCheckNotApplicable(check, fileType) || this.checksExecutedWithoutParsingByFiles.getOrDefault(inputFile, Collections.emptySet()).contains(check.getClass())) continue;
            if (check instanceof PythonSubscriptionCheck) {
                PythonSubscriptionCheck pythonSubscriptionCheck = (PythonSubscriptionCheck)check;
                subscriptionChecks.add(pythonSubscriptionCheck);
                continue;
            }
            check.scanFile(visitorContext);
        }
        SubscriptionVisitor.analyze(subscriptionChecks, visitorContext);
    }

    private void executeOtherChecks(PythonInputFile inputFile, PythonVisitorContext visitorContext, InputFile.Type fileType) {
        this.checks.noSonarPythonChecks().forEach((repositoryKey, repositoryChecks) -> this.runLockedByRepository((String)repositoryKey, () -> this.executeChecks(visitorContext, (Collection<PythonCheck>)repositoryChecks, fileType, inputFile)));
    }

    private void searchForDataBricks(PythonVisitorContext visitorContext) {
        boolean hasDatabricks = visitorContext.pythonFile().content().lines().anyMatch(line -> DATABRICKS_MAGIC_COMMAND_PATTERN.matcher((CharSequence)line).matches());
        this.foundDatabricks.compareAndSet(false, hasDatabricks);
    }

    private static PythonTreeMaker getTreeMaker(PythonInputFile inputFile) {
        return "py".equals(inputFile.wrappedFile().language()) ? new PythonTreeMaker() : new IPythonTreeMaker(PythonScanner.getOffsetLocations(inputFile));
    }

    private static Map<Integer, IPythonLocation> getOffsetLocations(PythonInputFile inputFile) {
        if (inputFile.kind() == PythonInputFile.Kind.IPYTHON) {
            return ((GeneratedIPythonFile)inputFile).locationMap();
        }
        return Map.of();
    }

    @Override
    public boolean scanFileWithoutParsing(PythonInputFile inputFile) {
        InputFile.Type fileType = inputFile.wrappedFile().type();
        boolean result = true;
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile.wrappedFile());
        PythonInputFileContext inputFileContext = new PythonInputFileContext(pythonFile, this.context.fileSystem().workDir(), this.indexer.cacheContext(), this.context.runtime().getProduct(), this.indexer.projectLevelSymbolTable());
        result = this.scanFileWithoutParsingSonarPython(inputFile, fileType, inputFileContext, result);
        AtomicBoolean atomicResult = new AtomicBoolean(result);
        Map<String, List<PythonCheck>> otherChecks = this.checks.noSonarPythonChecks();
        otherChecks.forEach((repositoryKey, repositoryChecks) -> this.runLockedByRepository((String)repositoryKey, () -> {
            for (PythonCheck check : repositoryChecks) {
                boolean scanResult = this.scanFileWithoutParsingNotSonarPython(inputFile, check, fileType, atomicResult.get(), inputFileContext);
                atomicResult.set(scanResult);
            }
        }));
        result = atomicResult.get();
        if (!(result &= this.architectureCallback.scanWithoutParsing(inputFileContext))) {
            return false;
        }
        return this.restoreAndPushMeasuresIfApplicable(inputFile);
    }

    private boolean scanFileWithoutParsingNotSonarPython(PythonInputFile inputFile, PythonCheck check, InputFile.Type fileType, boolean result, PythonInputFileContext inputFileContext) {
        if (this.isCheckNotApplicable(check, fileType)) {
            return result;
        }
        if (!this.indexer.canBeFullyScannedWithoutParsing(inputFile)) {
            result = false;
            return result;
        }
        if (check.scanWithoutParsing(inputFileContext)) {
            Set executedChecks = this.checksExecutedWithoutParsingByFiles.getOrDefault(inputFile, new HashSet());
            executedChecks.add(check.getClass());
            this.checksExecutedWithoutParsingByFiles.putIfAbsent(inputFile, executedChecks);
        } else {
            result = false;
        }
        return result;
    }

    private boolean scanFileWithoutParsingSonarPython(PythonInputFile inputFile, InputFile.Type fileType, PythonInputFileContext inputFileContext, boolean result) {
        List<PythonCheck> ourChecks = this.checks.sonarPythonChecks();
        for (PythonCheck check : ourChecks) {
            if (this.isCheckNotApplicable(check, fileType)) continue;
            if (check.scanWithoutParsing(inputFileContext)) {
                Set executedChecks = this.checksExecutedWithoutParsingByFiles.getOrDefault(inputFile, new HashSet());
                executedChecks.add(check.getClass());
                this.checksExecutedWithoutParsingByFiles.putIfAbsent(inputFile, executedChecks);
                continue;
            }
            result = false;
        }
        return result;
    }

    @Override
    public void endOfAnalysis() {
        this.indexer.postAnalysis(this.context);
        this.checks.sonarPythonEndOfAnalyses().forEach(c -> c.endOfAnalysis(this.indexer.cacheContext()));
        this.checks.noSonarPythonEndOfAnalyses().forEach(this::endOfAnalysisForRepository);
    }

    private void endOfAnalysisForRepository(String repositoryKey, List<EndOfAnalysis> endOfAnalyses) {
        this.runLockedByRepository(repositoryKey, () -> endOfAnalyses.forEach(c -> c.endOfAnalysis(this.indexer.cacheContext())));
    }

    boolean isCheckNotApplicable(PythonCheck pythonCheck, InputFile.Type fileType) {
        return fileType != InputFile.Type.MAIN && pythonCheck.scope() != PythonCheck.CheckScope.ALL;
    }

    static File getWorkingDirectory(SensorContext context) {
        return PythonScanner.isInSonarLint(context) ? null : context.fileSystem().workDir();
    }

    private static boolean isInSonarLint(SensorContext context) {
        return context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT);
    }

    @Override
    protected void processException(Exception e, PythonInputFile file) {
        LOG.warn("Unable to analyze file: " + file, (Throwable)e);
    }

    @Override
    public boolean canBeScannedWithoutParsing(PythonInputFile inputFile) {
        return this.indexer.canBePartiallyScannedWithoutParsing(inputFile);
    }

    @Override
    protected void reportStatistics(int numSkippedFiles, int numTotalFiles) {
        LOG.info("The Python analyzer was able to leverage cached data from previous analyses for {} out of {} files. These files were not parsed.", (Object)numSkippedFiles, (Object)numTotalFiles);
    }

    private boolean restoreAndPushMeasuresIfApplicable(PythonInputFile inputFile) {
        if (inputFile.wrappedFile().type() == InputFile.Type.TEST) {
            return true;
        }
        return this.cpdAnalyzer.pushCachedCpdTokens(inputFile.wrappedFile(), this.indexer.cacheContext());
    }

    public int getRecognitionErrorCount() {
        return this.recognitionErrorCount.get();
    }

    public boolean getFoundDatabricks() {
        return this.foundDatabricks.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLockedByRepository(String repositoryKey, Runnable runnable) {
        Lock repositoryLock = this.repositoryLocks.computeIfAbsent(repositoryKey, k -> new ReentrantLock());
        try {
            repositoryLock.lock();
            runnable.run();
        }
        finally {
            repositoryLock.unlock();
        }
    }
}

