/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.plugins.python.editions.RepositoryInfoProvider;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public class PythonProfile
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PythonProfile.class);
    static final String PROFILE_NAME = "Sonar way";
    static final String SECURITY_RULES_CLASS_NAME = "com.sonar.plugins.security.api.PythonRules";
    static final String SECURITY_RULE_KEYS_METHOD_NAME = "getRuleKeys";
    static final String DBD_RULES_CLASS_NAME = "com.sonarsource.plugins.dbd.api.PythonRules";
    static final String DBD_RULE_KEYS_METHOD_NAME = "getDataflowBugDetectionRuleKeys";
    static final String ARCHITECTURE_RULES_CLASS_NAME = "com.sonarsource.plugins.architecturepythonfrontend.api.ArchitecturePythonRules";
    static final String ARCHITECTURE_RULE_KEYS_METHOD_NAME = "getRuleKeys";
    static final String GET_REPOSITORY_KEY = "getRepositoryKey";
    private final RepositoryInfoProvider[] editionMetadataProviders;

    public PythonProfile(RepositoryInfoProvider[] editionMetadataProviders) {
        this.editionMetadataProviders = editionMetadataProviders;
    }

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(PROFILE_NAME, "py");
        for (RepositoryInfoProvider repositoryInfoProvider : this.editionMetadataProviders) {
            PythonProfile.registerRulesForEdition(repositoryInfoProvider, profile);
        }
        PythonProfile.getSecurityRuleKeys().forEach(key -> profile.activateRule(key.repository(), key.rule()));
        PythonProfile.getDataflowBugDetectionRuleKeys().forEach(key -> profile.activateRule(key.repository(), key.rule()));
        PythonProfile.getArchitectureRuleKeys().forEach(key -> profile.activateRule(key.repository(), key.rule()));
        profile.done();
    }

    private static void registerRulesForEdition(RepositoryInfoProvider repositoryInfoProvider, BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile) {
        RepositoryInfoProvider.RepositoryInfo repositoryInfo = repositoryInfoProvider.getInfo();
        BuiltInQualityProfileJsonLoader.load(profile, repositoryInfo.repositoryKey(), repositoryInfo.profileLocation());
        profile.activeRules().removeIf(rule -> repositoryInfo.disabledRules().contains(rule.ruleKey()));
    }

    static Set<RuleKey> getSecurityRuleKeys() {
        return PythonProfile.getExternalRuleKeys(SECURITY_RULES_CLASS_NAME, "getRuleKeys", "security");
    }

    static Set<RuleKey> getDataflowBugDetectionRuleKeys() {
        return PythonProfile.getExternalRuleKeys(DBD_RULES_CLASS_NAME, DBD_RULE_KEYS_METHOD_NAME, "dataflow bug detection");
    }

    static Set<RuleKey> getArchitectureRuleKeys() {
        return PythonProfile.getExternalRuleKeys(ARCHITECTURE_RULES_CLASS_NAME, "getRuleKeys", "architecture");
    }

    static Set<RuleKey> getExternalRuleKeys(String className, String ruleKeysMethodName, String rulesCategory) {
        try {
            Class<?> rulesClass = Class.forName(className);
            Method getRuleKeysMethod = rulesClass.getMethod(ruleKeysMethodName, new Class[0]);
            Set ruleKeys = (Set)getRuleKeysMethod.invoke(null, new Object[0]);
            Method getRepositoryKeyMethod = rulesClass.getMethod(GET_REPOSITORY_KEY, new Class[0]);
            String repositoryKey = (String)getRepositoryKeyMethod.invoke(null, new Object[0]);
            LOG.info("Getting rules from {}.{} for the category:{}", new Object[]{className, ruleKeysMethodName, rulesCategory});
            return ruleKeys.stream().map(k -> RuleKey.of((String)repositoryKey, (String)k)).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug(String.format("[%s], no %s rules added to Sonar way Python profile: %s", e.getClass().getSimpleName(), rulesCategory, e.getMessage()), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

