/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.python.EscapeCharPositionInfo;
import org.sonar.python.IPythonLocation;

public class NotebookParsingData {
    private StringBuilder aggregatedSource;
    private Map<Integer, IPythonLocation> locationMap;
    private Integer aggregatedSourceLine;

    public NotebookParsingData(StringBuilder aggregatedSource, Map<Integer, IPythonLocation> locationMap, Integer aggregatedSourceLine) {
        this.aggregatedSource = aggregatedSource;
        this.locationMap = locationMap;
        this.aggregatedSourceLine = aggregatedSourceLine;
    }

    public static NotebookParsingData fromLine(int line) {
        return new NotebookParsingData(new StringBuilder(), new LinkedHashMap<Integer, IPythonLocation>(), line);
    }

    public static NotebookParsingData empty() {
        return new NotebookParsingData(new StringBuilder(), new LinkedHashMap<Integer, IPythonLocation>(), 0);
    }

    public StringBuilder getAggregatedSource() {
        return this.aggregatedSource;
    }

    public Map<Integer, IPythonLocation> getLocationMap() {
        return this.locationMap;
    }

    public Integer getAggregatedSourceLine() {
        return this.aggregatedSourceLine;
    }

    public NotebookParsingData combine(NotebookParsingData other) {
        this.aggregatedSource.append((CharSequence)other.aggregatedSource);
        this.aggregatedSourceLine = other.aggregatedSourceLine;
        this.locationMap.putAll(other.locationMap);
        return this;
    }

    public void appendToSource(String str) {
        this.aggregatedSource.append(str);
    }

    public void addLineToSource(String sourceLine, int lineNr, int columnNr, List<EscapeCharPositionInfo> colOffsets, boolean isCompressed) {
        this.addLineToSource(sourceLine, new IPythonLocation(lineNr, columnNr, colOffsets, isCompressed));
    }

    private void appendLine(String line) {
        this.aggregatedSource.append(line);
        Integer n = this.aggregatedSourceLine;
        this.aggregatedSourceLine = this.aggregatedSourceLine + 1;
    }

    public void addLineToSource(String sourceLine, IPythonLocation location) {
        this.appendLine(sourceLine);
        this.locationMap.put(this.aggregatedSourceLine, location);
    }

    public void addDelimiterToSource(String delimiter, int lineNr, int columnNr) {
        this.appendLine(delimiter);
        this.addDefaultLocation(this.aggregatedSourceLine, lineNr, columnNr);
    }

    public void addDefaultLocation(int line, int lineNr, int columnNr) {
        this.locationMap.putIfAbsent(line, new IPythonLocation(lineNr, columnNr));
    }

    public void removeTrailingExtraLine() {
        if (!this.aggregatedSource.isEmpty() && this.aggregatedSource.charAt(this.aggregatedSource.length() - 1) == '\n') {
            this.aggregatedSource.deleteCharAt(this.aggregatedSource.length() - 1);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookParsingData that = (NotebookParsingData)o;
        return this.aggregatedSource.toString().contentEquals(that.aggregatedSource) && Objects.equals(this.locationMap, that.locationMap) && Objects.equals(this.aggregatedSourceLine, that.aggregatedSourceLine);
    }

    public int hashCode() {
        return Objects.hash(this.aggregatedSource, this.locationMap, this.aggregatedSourceLine);
    }
}

