/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.nosonar.NoSonarLineInfoCollector;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.metrics.FileMetrics;

public class MeasuresRepository {
    private final SensorContext context;
    private final NoSonarFilter noSonarFilter;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarLineInfoCollector noSonarLineInfoCollector;
    private final boolean isInSonarLint;
    private final Lock lock;

    public MeasuresRepository(SensorContext context, NoSonarFilter noSonarFilter, FileLinesContextFactory fileLinesContextFactory, boolean isInSonarLint, NoSonarLineInfoCollector noSonarLineInfoCollector, Lock lock) {
        this.context = context;
        this.noSonarFilter = noSonarFilter;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.isInSonarLint = isInSonarLint;
        this.noSonarLineInfoCollector = noSonarLineInfoCollector;
        this.lock = lock;
    }

    public void save(PythonInputFile inputFile, PythonVisitorContext visitorContext) {
        try {
            this.lock.lock();
            this.saveInternal(inputFile, visitorContext);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void saveInternal(PythonInputFile inputFile, PythonVisitorContext visitorContext) {
        FileMetrics fileMetrics = new FileMetrics(visitorContext, MeasuresRepository.isNotebook(inputFile));
        FileLinesVisitor fileLinesVisitor = fileMetrics.fileLinesVisitor();
        if (!this.isInSonarLint) {
            Set<Integer> linesOfCode = fileLinesVisitor.getLinesOfCode();
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.NCLOC, linesOfCode.size());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, fileMetrics.numberOfStatements());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, fileMetrics.numberOfFunctions());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.CLASSES, fileMetrics.numberOfClasses());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, fileMetrics.complexity());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, fileMetrics.cognitiveComplexity());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, fileLinesVisitor.getCommentLineCount());
            FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile.wrappedFile());
            if (inputFile.kind() == PythonInputFile.Kind.PYTHON) {
                for (int line : linesOfCode) {
                    fileLinesContext.setIntValue("ncloc_data", line, 1);
                }
            }
            for (int line : fileLinesVisitor.getExecutableLines()) {
                fileLinesContext.setIntValue("executable_lines_data", line, 1);
            }
            this.save(fileLinesContext);
        }
    }

    static boolean isNotebook(PythonInputFile inputFile) {
        return inputFile.kind() == PythonInputFile.Kind.IPYTHON;
    }

    private void saveMetricOnFile(PythonInputFile inputFile, Metric<Integer> metric, Integer value) {
        NewMeasure measure = this.context.newMeasure().withValue((Serializable)value).forMetric(metric).on((InputComponent)inputFile.wrappedFile());
        this.save((NewMeasure<Integer>)measure);
    }

    private void save(FileLinesContext fileLinesContext) {
        try {
            this.lock.lock();
            fileLinesContext.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void save(NewMeasure<Integer> measure) {
        try {
            this.lock.lock();
            measure.save();
        }
        finally {
            this.lock.unlock();
        }
    }
}

