/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.python.GeneratedIPythonFile;
import org.sonar.plugins.python.IpynbNotebookParser;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.PythonInputFileImpl;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.SensorTelemetryStorage;
import org.sonar.plugins.python.TelemetryMetricKey;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.architecture.DummyArchitectureCallback;
import org.sonar.plugins.python.editions.OpenSourceRepositoryInfoProvider;
import org.sonar.plugins.python.editions.RepositoryInfoProvider;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.plugins.python.indexer.SonarQubePythonIndexer;
import org.sonar.plugins.python.nosonar.NoSonarLineInfoCollector;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.project.config.ProjectConfigurationBuilder;

public final class IPynbSensor
implements Sensor {
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonIndexer indexer;
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    private final SensorTelemetryStorage sensorTelemetryStorage;
    private final NoSonarLineInfoCollector noSonarLineInfoCollector;
    private final ProjectConfigurationBuilder projectConfigurationBuilder;

    public IPynbSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, NoSonarLineInfoCollector noSonarLineInfoCollector, ProjectConfigurationBuilder projectConfigurationBuilder) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, new RepositoryInfoProvider[]{new OpenSourceRepositoryInfoProvider()}, noSonarLineInfoCollector, projectConfigurationBuilder);
    }

    public IPynbSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonIndexer indexer, RepositoryInfoProvider[] editionMetadataProviders, NoSonarLineInfoCollector noSonarLineInfoCollector, ProjectConfigurationBuilder projectConfigurationBuilder) {
        this.noSonarLineInfoCollector = noSonarLineInfoCollector;
        this.projectConfigurationBuilder = projectConfigurationBuilder;
        this.checks = IPynbSensor.createPythonChecks(checkFactory, editionMetadataProviders);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.indexer = indexer;
        this.sensorTelemetryStorage = new SensorTelemetryStorage();
    }

    private static PythonChecks createPythonChecks(CheckFactory checkFactory, RepositoryInfoProvider[] editionMetadataProviders) {
        PythonChecks checks = new PythonChecks(checkFactory);
        for (RepositoryInfoProvider repositoryInfoProvider : editionMetadataProviders) {
            RepositoryInfoProvider.RepositoryInfo repositoryInfo = repositoryInfoProvider.getIPynbInfo();
            checks.addChecks(repositoryInfo.repositoryKey(), repositoryInfo.checks());
        }
        return checks;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("ipynb").name("IPython Notebooks Sensor");
    }

    public void execute(SensorContext context) {
        Instant sensorStartTime = Instant.now();
        List<PythonInputFile> pythonFiles = IPynbSensor.getInputFiles(context);
        String[] pythonVersions = context.config().getStringArray("sonar.python.version");
        if (pythonVersions.length != 0) {
            ProjectPythonVersion.setCurrentVersions(PythonVersionUtils.fromStringArray(pythonVersions));
        }
        if (IPynbSensor.isInSonarLintRuntime(context)) {
            PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, PythonParser::createIPythonParser, this.indexer, new DummyArchitectureCallback(), this.noSonarLineInfoCollector);
            scanner.execute(pythonFiles, context);
        } else {
            this.processNotebooksFiles(pythonFiles, context);
            Duration sensorTime = Duration.between(sensorStartTime, Instant.now());
            this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOTEBOOKS_ANALYSIS_DURATION_KEY, sensorTime.getSeconds());
        }
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOSONAR_NOTEBOOK_RULE_ID_KEY, this.noSonarLineInfoCollector.getSuppressedRuleIds());
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOSONAR_NOTEBOOK_COMMENTS_KEY, this.noSonarLineInfoCollector.getCommentWithExactlyOneRuleSuppressed());
        this.sensorTelemetryStorage.send(context);
    }

    private void processNotebooksFiles(List<PythonInputFile> pythonFiles, SensorContext context) {
        pythonFiles = this.parseNotebooks(pythonFiles, context);
        CacheContextImpl cacheContext = CacheContextImpl.dummyCache();
        SonarQubePythonIndexer pythonIndexer = new SonarQubePythonIndexer(pythonFiles, cacheContext, context, this.projectConfigurationBuilder);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, PythonParser::createIPythonParser, pythonIndexer, new DummyArchitectureCallback(), this.noSonarLineInfoCollector);
        scanner.execute(pythonFiles, context);
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOTEBOOK_RECOGNITION_ERROR_KEY, scanner.getRecognitionErrorCount());
        this.updateDatabricksTelemetry(scanner);
    }

    private List<PythonInputFile> parseNotebooks(List<PythonInputFile> pythonFiles, SensorContext context) {
        ArrayList<PythonInputFile> generatedIPythonFiles = new ArrayList<PythonInputFile>();
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOTEBOOK_TOTAL_KEY, pythonFiles.size());
        int numberOfExceptions = 0;
        for (PythonInputFile inputFile : pythonFiles) {
            try {
                this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOTEBOOK_PRESENT_KEY, true);
                Optional<GeneratedIPythonFile> result = IpynbNotebookParser.parseNotebook(inputFile);
                result.ifPresent(generatedIPythonFiles::add);
            }
            catch (Exception e) {
                ++numberOfExceptions;
                if (!context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue() || IPynbSensor.isErrorOnTestFile(inputFile)) continue;
                throw new IllegalStateException("Exception when parsing " + inputFile, e);
            }
        }
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.NOTEBOOK_EXCEPTION_KEY, numberOfExceptions);
        return generatedIPythonFiles;
    }

    private static boolean isInSonarLintRuntime(SensorContext context) {
        return context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT);
    }

    private static List<PythonInputFile> getInputFiles(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(new FilePredicate[]{p.hasLanguage("ipynb")}));
        ArrayList list = new ArrayList();
        it.forEach(f -> list.add(new PythonInputFileImpl((InputFile)f)));
        return Collections.unmodifiableList(list);
    }

    private static boolean isErrorOnTestFile(PythonInputFile inputFile) {
        return inputFile.wrappedFile().type() == InputFile.Type.TEST;
    }

    private void updateDatabricksTelemetry(PythonScanner scanner) {
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.IPYNB_DATABRICKS_FOUND, scanner.getFoundDatabricks());
    }
}

