/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.List;
import java.util.Set;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public abstract class AbstractPythonRuleRepository
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    private final String repositoryKey;
    private final String resourceFolder;
    private final String languageKey;
    private final SonarRuntime sonarRuntime;

    protected AbstractPythonRuleRepository(String repositoryKey, String resourceFolder, String languageKey, SonarRuntime sonarRuntime) {
        this.repositoryKey = repositoryKey;
        this.resourceFolder = resourceFolder;
        this.languageKey = languageKey;
        this.sonarRuntime = sonarRuntime;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(REPOSITORY_NAME);
        RuleMetadataLoader loader = new RuleMetadataLoader(this.resourceFolder, this.resourceFolder + "/Sonar_way_profile.json", this.sonarRuntime);
        loader.addRulesByAnnotatedClass(repository, this.getCheckClasses());
        repository.rules().stream().filter(rule -> this.getTemplateRuleKeys().contains(rule.key())).forEach(rule -> rule.setTemplate(true));
        repository.rules().stream().filter(rule -> this.getDisabledRules().contains(rule.key())).forEach(rule -> rule.setActivatedByDefault(false));
        repository.done();
    }

    protected abstract List<Class<?>> getCheckClasses();

    protected Set<String> getTemplateRuleKeys() {
        return Set.of();
    }

    protected Set<String> getDisabledRules() {
        return Set.of();
    }
}

