/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure.log;

import java.util.function.Function;
import java.util.function.Supplier;
import org.sonarsource.performance.measure.log.JavaLoggerBridge;
import org.sonarsource.performance.measure.log.SonarSourceLoggerBridge;

public abstract class Logger {
    public static final String DEFAULT_SLF4J_LOGGER = "org.slf4j.LoggerFactory";
    private static String loggerImpl = "org.slf4j.LoggerFactory";
    public static final Function<Class<?>, Logger> DEFAULT_FACTORY = cls -> {
        try {
            Class.forName(loggerImpl);
            return new SonarSourceLoggerBridge((Class<?>)cls);
        }
        catch (ClassNotFoundException e2) {
            return new JavaLoggerBridge((Class<?>)cls);
        }
    };
    private static Function<Class<?>, Logger> factory = DEFAULT_FACTORY;

    public abstract void debug(Supplier<String> var1);

    public abstract void info(Supplier<String> var1);

    public abstract void warning(Supplier<String> var1);

    public abstract void error(Supplier<String> var1);

    public static Logger get(Class<?> cls) {
        return factory.apply(cls);
    }

    public static void overrideFactory(Function<Class<?>, Logger> factory2, String sonarLoggerClass) {
        factory = factory2;
        loggerImpl = sonarLoggerClass;
    }
}

