/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.performance.measure;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonarsource.performance.measure.DurationMeasure;
import org.sonarsource.performance.measure.MeasurementCost;

public final class DurationMeasureFiles {
    private static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().create();
    private static final DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance(Locale.ROOT);
    private static final NumberFormat TIME_FORMAT = new DecimalFormat("0.000000000", SYMBOLS);
    private static final NumberFormat RANK_FORMAT = new DecimalFormat("000", SYMBOLS);

    private DurationMeasureFiles() {
    }

    public static void writeJson(Path path, DurationMeasure measure) throws IOException {
        Files.write(path, DurationMeasureFiles.toJson(measure).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String toJson(DurationMeasure measure) {
        String json = GSON_PRETTY.toJson(DurationMeasureFiles.toJsonObject(measure));
        return json.replaceAll("\n *+(\"(?:name|calls|durationNanos|children)\":)", " $1").replaceAll("(\\d)\n *+\\}", "$1 }");
    }

    public static JsonObject toJsonObject(DurationMeasure measure) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", measure.name());
        jsonObject.addProperty("calls", measure.calls());
        jsonObject.addProperty("durationNanos", measure.durationNanos());
        if (!measure.hasChildren()) {
            jsonObject.add("children", measure.sortedChildren().stream().map(DurationMeasureFiles::toJsonObject).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        }
        return jsonObject;
    }

    public static DurationMeasure fromJsonWithoutObservationCost(Path performanceFile) throws IOException {
        DurationMeasure measure = DurationMeasureFiles.fromJson(performanceFile);
        return MeasurementCost.subtractObservationCost(measure);
    }

    public static DurationMeasure fromJson(Path performanceFile) throws IOException {
        return DurationMeasureFiles.fromJson(new String(Files.readAllBytes(performanceFile), StandardCharsets.UTF_8));
    }

    public static DurationMeasure fromJson(String json) {
        JsonObject jsonObject = GSON_PRETTY.fromJson(json, JsonObject.class);
        return DurationMeasureFiles.fromJson(jsonObject);
    }

    public static DurationMeasure fromJson(JsonObject jsonObject) {
        HashMap<String, DurationMeasure> childrenMap = null;
        JsonArray children2 = jsonObject.getAsJsonArray("children");
        if (children2 != null && children2.size() > 0) {
            childrenMap = new HashMap<String, DurationMeasure>();
            for (JsonElement child : children2) {
                DurationMeasure childMeasure = DurationMeasureFiles.fromJson(child.getAsJsonObject());
                childrenMap.merge(childMeasure.name(), childMeasure, DurationMeasure::merge);
            }
        }
        String name = jsonObject.getAsJsonPrimitive("name").getAsString();
        long calls = jsonObject.getAsJsonPrimitive("calls").getAsLong();
        long durationNanos = jsonObject.getAsJsonPrimitive("durationNanos").getAsLong();
        return new DurationMeasure(name, calls, durationNanos, childrenMap);
    }

    public static void writeStatistics(Path path, DurationMeasure measure, Map<String, String> categoryNames, Predicate<String> groupedMeasurePredicate) throws IOException {
        Files.write(path, DurationMeasureFiles.toStatistics(measure, categoryNames, groupedMeasurePredicate).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static String toStatistics(DurationMeasure measure, Map<String, String> categoryNames, Predicate<String> groupedMeasurePredicate) {
        Map<String, Set<String>> measureCategories = DurationMeasureFiles.categorizeMeasures(measure, categoryNames, Collections.emptySet());
        DurationMeasure measureWithoutGrouped = measure.copy();
        measureWithoutGrouped.remove("#MeasurementCost_v1");
        measureWithoutGrouped.remove("#MeasurementCost_subtracted_v1");
        Map<String, DurationMeasure> groupedMeasure = DurationMeasureFiles.extractGroupedMeasure(measureWithoutGrouped, groupedMeasurePredicate);
        StringBuilder stat = new StringBuilder();
        stat.append("Performance (in seconds without observation cost)\n");
        stat.append(DurationMeasureFiles.toTextTree(measureWithoutGrouped));
        stat.append("\n");
        if (!groupedMeasure.isEmpty()) {
            stat.append("Grouped Entries (in seconds without observation cost)\n");
            stat.append(DurationMeasureFiles.toRankedList(groupedMeasure, measureCategories));
        }
        return stat.toString();
    }

    private static Map<String, Set<String>> categorizeMeasures(DurationMeasure measure, Map<String, String> categoryNames, Set<String> parentCategories) {
        HashMap<String, Set<String>> categories = new HashMap<String, Set<String>>();
        String newCategory = categoryNames.get(measure.name());
        Set<String> measureCategorize = Collections.emptySet();
        if (!parentCategories.isEmpty() || newCategory != null) {
            measureCategorize = new TreeSet();
            categories.put(measure.name(), measureCategorize);
            measureCategorize.addAll(parentCategories);
            if (newCategory != null) {
                measureCategorize.add(newCategory);
            }
        }
        for (DurationMeasure child : measure.children()) {
            for (Map.Entry<String, Set<String>> childEntry : DurationMeasureFiles.categorizeMeasures(child, categoryNames, measureCategorize).entrySet()) {
                Set set = categories.computeIfAbsent(childEntry.getKey(), name -> new TreeSet());
                set.addAll((Collection)childEntry.getValue());
                if (newCategory == null) continue;
                set.add(newCategory);
            }
        }
        if (measureCategorize.isEmpty()) {
            categories.remove(measure.name());
        }
        return categories;
    }

    private static Map<String, DurationMeasure> extractGroupedMeasure(DurationMeasure measure, Predicate<String> groupedMeasurePredicate) {
        HashMap<String, DurationMeasure> groupedMap = new HashMap<String, DurationMeasure>();
        measure.children().stream().map(child -> DurationMeasureFiles.extractGroupedMeasure(child, groupedMeasurePredicate)).forEach(childMap -> childMap.values().forEach(child -> groupedMap.merge(child.name(), child.copy(), DurationMeasure::merge)));
        DurationMeasure substitutedChild = new DurationMeasure("[ 0 grouped measure(s) ]");
        long groupedCount = 0L;
        for (DurationMeasure child2 : new ArrayList<DurationMeasure>(measure.children())) {
            if (!groupedMeasurePredicate.test(child2.name())) continue;
            ++groupedCount;
            measure.remove(child2.name());
            substitutedChild.addCalls(child2.calls(), child2.durationNanos());
            groupedMap.merge(child2.name(), child2.copy(), DurationMeasure::merge);
        }
        if (groupedCount > 0L) {
            substitutedChild.rename("[ " + groupedCount + " grouped measure(s) ]");
            measure.addOrMerge(substitutedChild);
        }
        return groupedMap;
    }

    public static String toTextTree(DurationMeasure measure) {
        StringBuilder out = new StringBuilder();
        DurationMeasureFiles.toTextTreeOrderedByDuration(out, measure, "");
        return out.toString();
    }

    private static void toTextTreeOrderedByDuration(StringBuilder out, DurationMeasure measure, String indent) {
        out.append(indent).append("\u2022 ").append(DurationMeasureFiles.toSeconds(measure.durationNanos())).append(" ").append(measure.name()).append("\n");
        measure.children().stream().sorted(Comparator.comparing(x2 -> -x2.durationNanos())).forEach(child -> DurationMeasureFiles.toTextTreeOrderedByDuration(out, child, indent + "    "));
    }

    private static String toSeconds(long durationNanos) {
        double seconds = (double)durationNanos / 1.0E9;
        return String.format("%13s", TIME_FORMAT.format(seconds));
    }

    public static String toRankedList(Map<String, DurationMeasure> groupedMeasure, Map<String, Set<String>> measureCategories) {
        StringBuilder out = new StringBuilder();
        long totalDuration = groupedMeasure.values().stream().mapToLong(DurationMeasure::durationNanos).sum();
        out.append("Total   ").append(DurationMeasureFiles.toSeconds(totalDuration)).append("\n");
        List checkMeasures = groupedMeasure.values().stream().sorted(Comparator.comparing(c2 -> -c2.durationNanos())).collect(Collectors.toList());
        for (int i2 = 0; i2 < checkMeasures.size(); ++i2) {
            DurationMeasure measure = (DurationMeasure)checkMeasures.get(i2);
            Object categoryList = "";
            Set<String> categories = measureCategories.get(measure.name());
            if (categories != null) {
                categoryList = " (" + String.join((CharSequence)", ", categories) + ")";
            }
            out.append(DurationMeasureFiles.toRank(i2, checkMeasures)).append(" ").append(DurationMeasureFiles.toSeconds(measure.durationNanos())).append(" ").append(String.format("%-50s", measure.name())).append((String)categoryList).append("\n");
            measure.children().stream().sorted(Comparator.comparing(x2 -> -x2.durationNanos())).forEach(child -> DurationMeasureFiles.toTextTreeOrderedByDuration(out, child, "        "));
        }
        return out.toString();
    }

    private static String toRank(long index2, Collection<?> collection) {
        return RANK_FORMAT.format(index2 + 1L) + "/" + RANK_FORMAT.format(collection.size());
    }
}

