/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;
import org.sonar.api.scan.filesystem.PathResolver;

public final class SurefireUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurefireUtils.class);
    public static final String SUREFIRE_REPORT_PATHS_PROPERTY = "sonar.junit.reportPaths";

    private SurefireUtils() {
    }

    public static List<File> getReportsDirectories(Configuration settings, FileSystem fs, PathResolver pathResolver) {
        List<File> dirs = SurefireUtils.getReportsDirectoriesFromProperty(settings, fs, pathResolver);
        if (dirs != null) {
            return dirs;
        }
        return Collections.singletonList(new File(fs.baseDir(), "target/surefire-reports"));
    }

    private static List<File> getReportsDirectoriesFromProperty(Configuration settings, FileSystem fs, PathResolver pathResolver) {
        if (settings.hasKey(SUREFIRE_REPORT_PATHS_PROPERTY)) {
            return Arrays.stream(settings.getStringArray(SUREFIRE_REPORT_PATHS_PROPERTY)).map(String::trim).map(path -> SurefireUtils.getFileFromPath(fs, pathResolver, path)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    private static File getFileFromPath(FileSystem fs, PathResolver pathResolver, String path) {
        try {
            return pathResolver.relativeFile(fs.baseDir(), path);
        }
        catch (Exception e2) {
            LOGGER.info("Surefire report path: {}/{} not found.", (Object)fs.baseDir(), (Object)path);
            return null;
        }
    }
}

