/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.cpd;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitor;
import org.sonarsource.kotlin.plugin.cpd.CPDToken;
import org.sonarsource.kotlin.plugin.cpd.CachingKt;
import org.sonarsource.kotlin.plugin.cpd.CopyPasteDetectorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0002J&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/plugin/cpd/CopyPasteDetector;", "Lorg/sonarsource/kotlin/api/visiting/KotlinFileVisitor;", "<init>", "()V", "visit", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "collectCpdRelevantNodes", "", "Lcom/intellij/psi/PsiElement;", "node", "acc", "", "isExcludedFromCpd", "", "cacheTokensForNextAnalysis", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "tokens", "Lorg/sonarsource/kotlin/plugin/cpd/CPDToken;", "sonar-kotlin-plugin"})
public final class CopyPasteDetector
extends KotlinFileVisitor {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(@NotNull KotlinFileContext kotlinFileContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        SensorContext sensorContext = kotlinFileContext.getInputFileContext().getSensorContext();
        NewCpdTokens cpdTokens = sensorContext.newCpdTokens().onFile(kotlinFileContext.getInputFileContext().getInputFile());
        Iterable $this$map$iv = CopyPasteDetector.collectCpdRelevantNodes$default(this, kotlinFileContext.getKtFile(), null, 2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String text = node instanceof KtStringTemplateExpression ? "LITERAL" : node.getText();
            TextRange textRange = KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)node);
            Intrinsics.checkNotNull(text);
            CPDToken cpdToken = new CPDToken(textRange, text);
            cpdTokens.addToken(cpdToken.getRange(), cpdToken.getText());
            collection.add(cpdToken);
        }
        List tokens = (List)destination$iv$iv;
        cpdTokens.save();
        this.cacheTokensForNextAnalysis(sensorContext, kotlinFileContext.getInputFileContext().getInputFile(), tokens);
    }

    private final List<PsiElement> collectCpdRelevantNodes(PsiElement node, List<PsiElement> acc) {
        if (!this.isExcludedFromCpd(node)) {
            if (node instanceof LeafPsiElement && !(node instanceof PsiWhiteSpace) || node instanceof KtStringTemplateExpression) {
                acc.add(node);
            } else {
                Sequence $this$forEach$iv = PsiUtilsKt.getAllChildren(node);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    this.collectCpdRelevantNodes(it, acc);
                }
            }
        }
        return acc;
    }

    static /* synthetic */ List collectCpdRelevantNodes$default(CopyPasteDetector copyPasteDetector, PsiElement psiElement, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = new ArrayList();
        }
        return copyPasteDetector.collectCpdRelevantNodes(psiElement, list);
    }

    private final boolean isExcludedFromCpd(PsiElement node) {
        return node instanceof KtPackageDirective || node instanceof KtImportList || node instanceof KtImportDirective || node instanceof KtFileAnnotationList || node instanceof PsiWhiteSpace || node instanceof PsiComment || node instanceof KDoc;
    }

    private final void cacheTokensForNextAnalysis(SensorContext sensorContext, InputFile inputFile, List<CPDToken> tokens) {
        if (ApiExtensionsKt.hasCacheEnabled(sensorContext)) {
            CopyPasteDetectorKt.access$getLOG$p().trace("Caching " + tokens.size() + " CPD tokens for next analysis of input file " + inputFile.key() + ".");
            WriteCache nextCache = sensorContext.nextCache();
            Intrinsics.checkNotNull(nextCache);
            CachingKt.storeCPDTokens(nextCache, inputFile, tokens);
        } else {
            CopyPasteDetectorKt.access$getLOG$p().trace("No CPD tokens cached for next analysis of input file moduleKey:dummy.kt.");
        }
    }
}

