/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.cpd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonarsource.kotlin.plugin.KotlinSensor;
import org.sonarsource.kotlin.plugin.cpd.CPDToken;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\u001a\u001a\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0012\u0010\u000f\u001a\u00020\f*\u00020\r2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u001a\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DELIMITER", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "loadCPDTokens", "", "Lorg/sonarsource/kotlin/plugin/cpd/CPDToken;", "Lorg/sonar/api/batch/sensor/cache/ReadCache;", "file", "Lorg/sonar/api/batch/fs/InputFile;", "storeCPDTokens", "", "Lorg/sonar/api/batch/sensor/cache/WriteCache;", "tokens", "copyCPDTokensFromPrevious", "computeCPDTokensCacheKey", "serialize", "", "deserialize", "inputFile", "serialized", "stringToCPDToken", "sonar-kotlin-plugin"})
public final class CachingKt {
    private static final char DELIMITER = '\u001f';
    private static final Logger LOG = LoggerFactory.getLogger(KotlinSensor.class);

    @Nullable
    public static final List<CPDToken> loadCPDTokens(@NotNull ReadCache $this$loadCPDTokens, @NotNull InputFile file) {
        Intrinsics.checkNotNullParameter($this$loadCPDTokens, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        String key = CachingKt.computeCPDTokensCacheKey(file);
        if (!$this$loadCPDTokens.contains(key)) {
            return null;
        }
        byte[] serialized = $this$loadCPDTokens.read(key).readAllBytes();
        Intrinsics.checkNotNull(serialized);
        return CachingKt.deserialize(file, serialized);
    }

    @NotNull
    public static final String storeCPDTokens(@NotNull WriteCache $this$storeCPDTokens, @NotNull InputFile file, @NotNull List<CPDToken> tokens) {
        Intrinsics.checkNotNullParameter($this$storeCPDTokens, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        String key = CachingKt.computeCPDTokensCacheKey(file);
        byte[] data2 = CachingKt.serialize(tokens);
        try {
            $this$storeCPDTokens.write(key, data2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Could not write CPD tokens under key " + key + " in cache.");
        }
        return key;
    }

    @NotNull
    public static final String copyCPDTokensFromPrevious(@NotNull WriteCache $this$copyCPDTokensFromPrevious, @NotNull InputFile file) {
        Intrinsics.checkNotNullParameter($this$copyCPDTokensFromPrevious, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        String key = CachingKt.computeCPDTokensCacheKey(file);
        try {
            $this$copyCPDTokensFromPrevious.copyFromPrevious(key);
        }
        catch (IllegalArgumentException toRethrow) {
            LOG.warn("Could not copy CPD tokens from previous analysis for key " + key + ".");
            throw toRethrow;
        }
        return key;
    }

    @NotNull
    public static final String computeCPDTokensCacheKey(@NotNull InputFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return "kotlin:cpdTokens:" + file.key();
    }

    @NotNull
    public static final byte[] serialize(@NotNull List<CPDToken> tokens) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        return StringsKt.encodeToByteArray(CollectionsKt.joinToString$default(tokens, "\u001f", null, null, 0, null, CachingKt::serialize$lambda$0, 30, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CPDToken> deserialize(@NotNull InputFile inputFile, @NotNull byte[] serialized) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputFile, "inputFile");
        Intrinsics.checkNotNullParameter(serialized, "serialized");
        Object object = new char[]{'\u001f'};
        List stringTokens = StringsKt.split$default((CharSequence)StringsKt.decodeToString(serialized), object, false, 0, 6, null);
        Iterable $this$mapNotNull$iv = stringTokens;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CPDToken it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (CachingKt.stringToCPDToken(inputFile, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        char[] it = object = (Object)((List)destination$iv$iv);
        boolean bl = false;
        LOG.trace(it.size() + " out of " + stringTokens.size() + " CPD token(s) were successfully deserialized for file " + inputFile.key() + ".");
        return object;
    }

    private static final CPDToken stringToCPDToken(InputFile inputFile, String serialized) {
        CPDToken cPDToken;
        if (StringsKt.isBlank(serialized)) {
            return null;
        }
        try {
            String[] stringArray = new String[]{","};
            List tokens = StringsKt.split$default((CharSequence)serialized, stringArray, false, 5, 2, null);
            TextRange range = inputFile.newRange(Integer.parseInt((String)tokens.get(0)), Integer.parseInt((String)tokens.get(1)), Integer.parseInt((String)tokens.get(2)), Integer.parseInt((String)tokens.get(3)));
            String text = (String)tokens.get(4);
            Intrinsics.checkNotNull(range);
            cPDToken = new CPDToken(range, text);
        }
        catch (RuntimeException exception) {
            CPDToken cPDToken2;
            RuntimeException runtimeException = exception;
            if (runtimeException instanceof IndexOutOfBoundsException || runtimeException instanceof NumberFormatException) {
                cPDToken2 = null;
            } else {
                LOG.warn("An unexpected RuntimeException was caught when trying to deserialize a CPD token of " + inputFile.key() + ": " + exception.getMessage());
                cPDToken2 = null;
            }
            cPDToken = cPDToken2;
        }
        return cPDToken;
    }

    private static final CharSequence serialize$lambda$0(CPDToken it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getRange().start().line() + "," + it.getRange().start().lineOffset() + "," + it.getRange().end().line() + "," + it.getRange().end().lineOffset() + "," + it.getText();
    }
}

