/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin;

import com.sonarsource.plugins.kotlin.api.KotlinPluginExtensionsProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.plugin.ExtensionsClassLoader;
import org.sonarsource.kotlin.plugin.KotlinPluginExtensions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011J\u001c\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00120\u0011J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012J\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/plugin/KotlinPluginExtensions;", "", "providers", "", "Lcom/sonarsource/plugins/kotlin/api/KotlinPluginExtensionsProvider;", "<init>", "([Lcom/sonarsource/plugins/kotlin/api/KotlinPluginExtensionsProvider;)V", "classLoader", "Lorg/sonarsource/kotlin/plugin/ExtensionsClassLoader;", "repositories", "", "", "rulesByRepositoryKey", "", "Ljava/lang/Class;", "rulesEnabledInSonarWayProfile", "Lorg/sonar/api/rule/RuleKey;", "", "", "ruleMetadataLoaderClass", "sonar-kotlin-plugin"})
public final class KotlinPluginExtensions {
    @NotNull
    private final ExtensionsClassLoader classLoader;
    @NotNull
    private final Map<String, String> repositories;
    @NotNull
    private final Map<String, List<Class<?>>> rulesByRepositoryKey;
    @NotNull
    private final List<RuleKey> rulesEnabledInSonarWayProfile;

    public KotlinPluginExtensions(@NotNull KotlinPluginExtensionsProvider[] providers) {
        Class<?> providerClass;
        KotlinPluginExtensionsProvider it;
        KotlinPluginExtensionsProvider element$iv;
        int n2;
        Intrinsics.checkNotNullParameter(providers, "providers");
        this.repositories = new LinkedHashMap();
        this.rulesByRepositoryKey = new LinkedHashMap();
        this.rulesEnabledInSonarWayProfile = new ArrayList();
        Map classLoaders = new LinkedHashMap();
        KotlinPluginExtensionsProvider[] $this$forEach$iv = providers;
        boolean $i$f$forEach = false;
        int n3 = $this$forEach$iv.length;
        for (n2 = 0; n2 < n3; ++n2) {
            it = element$iv = $this$forEach$iv[n2];
            boolean bl = false;
            providerClass = it.getClass();
            classLoaders.put(providerClass.getPackageName() + ".", providerClass.getClassLoader());
        }
        classLoaders.put("org.sonarsource.analyzer.commons.", this.getClass().getClassLoader());
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        this.classLoader = new ExtensionsClassLoader(classLoader, classLoaders);
        $this$forEach$iv = providers;
        $i$f$forEach = false;
        n3 = $this$forEach$iv.length;
        for (n2 = 0; n2 < n3; ++n2) {
            it = element$iv = $this$forEach$iv[n2];
            boolean bl = false;
            providerClass = it.getClass();
            ClassLoader classLoader2 = providerClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue(classLoader2, "getClassLoader(...)");
            String string = providerClass.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            Class<?> clazz = this.classLoader.defineClass(classLoader2, string);
            Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<com.sonarsource.plugins.kotlin.api.KotlinPluginExtensionsProvider>");
            KotlinPluginExtensionsProvider provider2 = (KotlinPluginExtensionsProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            provider2.registerKotlinPluginExtensions(new KotlinPluginExtensionsProvider.Extensions(this){
                final /* synthetic */ KotlinPluginExtensions this$0;
                {
                    this.this$0 = $receiver;
                }

                public void registerRepository(String repositoryKey, String name) {
                    Intrinsics.checkNotNullParameter(repositoryKey, "repositoryKey");
                    Intrinsics.checkNotNullParameter(name, "name");
                    KotlinPluginExtensions.access$getRepositories$p(this.this$0).put(repositoryKey, name);
                }

                public void registerRule(String repositoryKey, Class<?> ruleClass, boolean enabledInSonarWay) {
                    Intrinsics.checkNotNullParameter(repositoryKey, "repositoryKey");
                    Intrinsics.checkNotNullParameter(ruleClass, "ruleClass");
                    String ruleKey = ((Rule)AnnotationUtils.getAnnotation(ruleClass, Rule.class)).key();
                    KotlinPluginExtensions.access$getRulesByRepositoryKey$p(this.this$0).computeIfAbsent(repositoryKey, arg_0 -> 2.1.registerRule$lambda$1(2.1::registerRule$lambda$0, arg_0)).add(ruleClass);
                    if (enabledInSonarWay) {
                        List list = KotlinPluginExtensions.access$getRulesEnabledInSonarWayProfile$p(this.this$0);
                        RuleKey ruleKey2 = RuleKey.of((String)repositoryKey, (String)ruleKey);
                        Intrinsics.checkNotNullExpressionValue(ruleKey2, "of(...)");
                        list.add(ruleKey2);
                    }
                }

                private static final List registerRule$lambda$0(String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return new ArrayList<E>();
                }

                private static final List registerRule$lambda$1(Function1 $tmp0, Object p0) {
                    return (List)$tmp0.invoke(p0);
                }
            });
        }
    }

    @NotNull
    public final Map<String, String> repositories() {
        return this.repositories;
    }

    @NotNull
    public final Map<String, List<Class<?>>> rulesByRepositoryKey() {
        return this.rulesByRepositoryKey;
    }

    @NotNull
    public final List<RuleKey> rulesEnabledInSonarWayProfile() {
        return this.rulesEnabledInSonarWayProfile;
    }

    @NotNull
    public final Class<?> ruleMetadataLoaderClass() {
        Class<?> clazz = this.classLoader.loadClass("org.sonarsource.analyzer.commons.RuleMetadataLoader");
        Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
        return clazz;
    }

    public static final /* synthetic */ Map access$getRepositories$p(KotlinPluginExtensions $this) {
        return $this.repositories;
    }

    public static final /* synthetic */ Map access$getRulesByRepositoryKey$p(KotlinPluginExtensions $this) {
        return $this.rulesByRepositoryKey;
    }

    public static final /* synthetic */ List access$getRulesEnabledInSonarWayProfile$p(KotlinPluginExtensions $this) {
        return $this.rulesEnabledInSonarWayProfile;
    }
}

