/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/metrics/SyntaxHighlighter;", "Lorg/sonarsource/kotlin/api/visiting/KotlinFileVisitor;", "<init>", "()V", "visit", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "highlightElementsRec", "node", "Lcom/intellij/psi/PsiElement;", "newHighlighting", "Lorg/sonar/api/batch/sensor/highlighting/NewHighlighting;", "context", "determineTypeOfText", "Lorg/sonar/api/batch/sensor/highlighting/TypeOfText;", "Lcom/intellij/psi/impl/source/tree/LeafPsiElement;", "sonar-kotlin-metrics"})
public final class SyntaxHighlighter
extends KotlinFileVisitor {
    @Override
    public void visit(@NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        NewHighlighting newHighlighting = kotlinFileContext.getInputFileContext().getSensorContext().newHighlighting().onFile(kotlinFileContext.getInputFileContext().getInputFile());
        PsiElement psiElement = kotlinFileContext.getKtFile();
        Intrinsics.checkNotNull(newHighlighting);
        this.highlightElementsRec(psiElement, newHighlighting, kotlinFileContext);
        newHighlighting.save();
    }

    private final void highlightElementsRec(PsiElement node, NewHighlighting newHighlighting, KotlinFileContext context) {
        TypeOfText typeOfText = this.determineTypeOfText(node);
        if (typeOfText != null) {
            newHighlighting.highlight(KotlinTextRanges.INSTANCE.textRange(context, node), typeOfText);
        } else {
            Sequence $this$forEach$iv = PsiUtilsKt.getAllChildren(node);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                this.highlightElementsRec(it, newHighlighting, context);
            }
        }
    }

    private final TypeOfText determineTypeOfText(PsiElement node) {
        PsiElement psiElement = node;
        return psiElement instanceof PsiAnnotation ? TypeOfText.ANNOTATION : (psiElement instanceof KtAnnotationEntry ? TypeOfText.ANNOTATION : (psiElement instanceof PsiDocComment ? TypeOfText.STRUCTURED_COMMENT : (psiElement instanceof KDoc ? TypeOfText.STRUCTURED_COMMENT : (psiElement instanceof PsiComment ? TypeOfText.COMMENT : (psiElement instanceof PsiKeyword ? TypeOfText.KEYWORD : (psiElement instanceof PsiLiteral ? TypeOfText.CONSTANT : (psiElement instanceof KtConstantExpression ? TypeOfText.CONSTANT : (psiElement instanceof KtStringTemplateExpression ? TypeOfText.STRING : (psiElement instanceof LeafPsiElement ? this.determineTypeOfText((LeafPsiElement)node) : null)))))))));
    }

    private final TypeOfText determineTypeOfText(LeafPsiElement node) {
        return node.getElementType() instanceof KtKeywordToken ? TypeOfText.KEYWORD : null;
    }
}

