/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.InputFileContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0002\u001a,\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002\u001a&\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"NOSONAR_PREFIX", "", "saveMetric", "", "ctx", "Lorg/sonarsource/kotlin/api/checks/InputFileContext;", "metric", "Lorg/sonar/api/batch/measure/Metric;", "", "value", "addCommentMetrics", "comment", "Lcom/intellij/psi/PsiComment;", "commentLines", "", "nosonarLines", "add", "range", "Lcom/intellij/openapi/util/TextRange;", "lineNumbers", "document", "Lcom/intellij/openapi/editor/Document;", "isNosonarComment", "", "sonar-kotlin-metrics"})
public final class MetricVisitorKt {
    @NotNull
    public static final String NOSONAR_PREFIX = "NOSONAR";

    private static final void saveMetric(InputFileContext ctx, Metric<Integer> metric, int value2) {
        ctx.getSensorContext().newMeasure().on((InputComponent)ctx.getInputFile()).forMetric(metric).withValue((Serializable)Integer.valueOf(value2)).save();
    }

    private static final void addCommentMetrics(PsiComment comment, Set<Integer> commentLines, Set<Integer> nosonarLines) {
        Document document = comment.getContainingFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        Document document2 = document;
        if (MetricVisitorKt.isNosonarComment(comment)) {
            TextRange textRange = comment.getTextRange();
            Intrinsics.checkNotNullExpressionValue(textRange, "getTextRange(...)");
            MetricVisitorKt.add(textRange, nosonarLines, document2);
        } else {
            TextRange textRange = comment.getTextRange();
            Intrinsics.checkNotNullExpressionValue(textRange, "getTextRange(...)");
            MetricVisitorKt.add(textRange, commentLines, document2);
        }
    }

    private static final void add(TextRange range, Set<Integer> lineNumbers, Document document) {
        int startLine = document.getLineNumber(range.getStartOffset()) + 1;
        int endLine = document.getLineNumber(range.getEndOffset()) + 1;
        CollectionsKt.addAll((Collection)lineNumbers, new IntRange(startLine, endLine));
    }

    public static final boolean isNosonarComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        String string = ApiExtensionsKt.getContent(comment);
        Intrinsics.checkNotNullExpressionValue(string, "getContent(...)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        return StringsKt.startsWith$default(string2, NOSONAR_PREFIX, false, 2, null);
    }

    public static final /* synthetic */ void access$saveMetric(InputFileContext ctx, Metric metric, int value2) {
        MetricVisitorKt.saveMetric(ctx, (Metric<Integer>)metric, value2);
    }

    public static final /* synthetic */ void access$addCommentMetrics(PsiComment comment, Set commentLines, Set nosonarLines) {
        MetricVisitorKt.addCommentMetrics(comment, commentLines, nosonarLines);
    }
}

