/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.checks.CognitiveComplexity;
import org.sonarsource.kotlin.metrics.CyclomaticComplexityVisitor;
import org.sonarsource.kotlin.metrics.KtMetricVisitor$visitKtFile$;
import org.sonarsource.kotlin.metrics.MetricVisitorKt;
import org.sonarsource.kotlin.metrics.StatementsVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020!2\f\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u000208H\u0002R*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Lorg/sonarsource/kotlin/metrics/KtMetricVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "value", "", "", "linesOfCode", "getLinesOfCode", "()Ljava/util/Set;", "", "commentLines", "getCommentLines", "nosonarLines", "getNosonarLines", "executableLines", "getExecutableLines", "numberOfFunctions", "getNumberOfFunctions", "()I", "numberOfClasses", "getNumberOfClasses", "complexity", "getComplexity", "statements", "getStatements", "cognitiveComplexity", "getCognitiveComplexity", "", "hasAndroidImports", "getHasAndroidImports", "()Z", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitComment", "comment", "Lcom/intellij/psi/PsiComment;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "addExecutableLines", "elements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "document", "Lcom/intellij/openapi/editor/Document;", "Companion", "sonar-kotlin-metrics"})
final class KtMetricVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private Set<Integer> linesOfCode = new LinkedHashSet();
    @NotNull
    private Set<Integer> commentLines = new LinkedHashSet();
    @NotNull
    private Set<Integer> nosonarLines = new LinkedHashSet();
    @NotNull
    private Set<Integer> executableLines = new LinkedHashSet();
    private int numberOfFunctions;
    private int numberOfClasses;
    private int complexity;
    private int statements;
    private int cognitiveComplexity;
    private boolean hasAndroidImports;
    @NotNull
    private static final Set<Name> ANDROID_PACKAGES;

    @NotNull
    public final Set<Integer> getLinesOfCode() {
        return this.linesOfCode;
    }

    @NotNull
    public final Set<Integer> getCommentLines() {
        return this.commentLines;
    }

    @NotNull
    public final Set<Integer> getNosonarLines() {
        return this.nosonarLines;
    }

    @NotNull
    public final Set<Integer> getExecutableLines() {
        return this.executableLines;
    }

    public final int getNumberOfFunctions() {
        return this.numberOfFunctions;
    }

    public final int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    public final int getComplexity() {
        return this.complexity;
    }

    public final int getStatements() {
        return this.statements;
    }

    public final int getCognitiveComplexity() {
        return this.cognitiveComplexity;
    }

    public final boolean getHasAndroidImports() {
        return this.hasAndroidImports;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        this.linesOfCode = ApiExtensionsKt.linesOfCode(file);
        CyclomaticComplexityVisitor complexityVisitor = new CyclomaticComplexityVisitor();
        file.accept(complexityVisitor);
        this.complexity = complexityVisitor.complexityTrees().size();
        this.cognitiveComplexity = new CognitiveComplexity(file).value();
        StatementsVisitor statementsVisitor = new StatementsVisitor();
        file.accept(statementsVisitor);
        this.statements = statementsVisitor.getStatements();
        PsiElement[] psiElementArray = file.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        Object[] objectArray = psiElementArray;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList<Object> list$iv = new ArrayList<Object>();
        for (Object item$iv : objectArray) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it = (PsiElement)item$iv;
            boolean bl2 = false;
            if (it instanceof PsiComment || it instanceof PsiWhiteSpace) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        Iterable iterable = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.accept(this);
        }
        PsiFile psiFile = file.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        PsiElement psiElement = psiFile;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = psiElement;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement bl = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void bl2 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KDoc, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDoc) {
                    this.$action.invoke(element);
                }
            }
        });
        Iterable iterable2 = (List)to$iv$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : iterable2) {
            KDoc it = (KDoc)element$iv;
            boolean bl3 = false;
            MetricVisitorKt.access$addCommentMetrics(it, this.commentLines, this.nosonarLines);
        }
    }

    @Override
    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        MetricVisitorKt.access$addCommentMetrics(comment, this.commentLines, this.nosonarLines);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.hasBody() && function2.getName() != null) {
            int n2 = this.numberOfFunctions;
            this.numberOfFunctions = n2 + 1;
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        int n2 = this.numberOfClasses;
        this.numberOfClasses = n2 + 1;
        super.visitClass(klass);
    }

    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        List<KtExpression> list = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Document document = expression.getContainingKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        this.addExecutableLines(list, document);
        super.visitBlockExpression(expression);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitImportDirective(@NotNull KtImportDirective importDirective) {
        block7: {
            Intrinsics.checkNotNullParameter(importDirective, "importDirective");
            v0 = this;
            if (this.hasAndroidImports) ** GOTO lbl-1000
            var2_2 = KtMetricVisitor.ANDROID_PACKAGES;
            var8_3 = v0;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (Name)element$iv;
                    $i$a$-any-KtMetricVisitor$visitImportDirective$1 = false;
                    v2 = importDirective.getImportPath();
                    if (v2 != null && (v2 = v2.getFqName()) != null) {
                        Intrinsics.checkNotNull(it);
                        v3 = v2.startsWith(it);
                    } else {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v1 = true;
                    break block7;
                }
                v1 = false;
            }
        }
        var9_9 = v1;
        v0 = var8_3;
        if (var9_9) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        v0.hasAndroidImports = v4;
        super.visitImportDirective(importDirective);
    }

    private final void addExecutableLines(List<? extends KtElement> elements, Document document) {
        Sequence<KtElement> $this$forEach$iv = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)elements), KtMetricVisitor::addExecutableLines$lambda$4);
        boolean $i$f$forEach = false;
        Iterator<KtElement> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement element$iv;
            KtElement it = element$iv = iterator2.next();
            boolean bl = false;
            this.executableLines.add(document.getLineNumber(it.getTextRange().getStartOffset()) + 1);
        }
    }

    private static final boolean addExecutableLines$lambda$4(KtElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtPackageDirective || it instanceof KtImportDirective || it instanceof KtClassOrObject || it instanceof KtNamedFunction || it instanceof KtBlockExpression;
    }

    static {
        Name[] nameArray = new Name[]{Name.identifier("android"), Name.identifier("androidx")};
        ANDROID_PACKAGES = SetsKt.setOf(nameArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/metrics/KtMetricVisitor$Companion;", "", "<init>", "()V", "ANDROID_PACKAGES", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "getANDROID_PACKAGES", "()Ljava/util/Set;", "sonar-kotlin-metrics"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Name> getANDROID_PACKAGES() {
            return ANDROID_PACKAGES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

