/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.MessageKt;
import org.sonarsource.kotlin.gradle.checks.AssignmentChecker;

@Rule(key="S6626")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/TaskDefinitionsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isTasksRegisterCall", "", "getLastArgumentLambdaOrNull", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "sonar-kotlin-gradle"})
public final class TaskDefinitionsCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        KtElement ktElement;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.isTasksRegisterCall(expression)) {
            return;
        }
        KtLambdaArgument ktLambdaArgument = this.getLastArgumentLambdaOrNull(expression);
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambdaArg = ktLambdaArgument;
        LazyParseablePsiElement lazyParseablePsiElement = lambdaArg.getLambdaExpression();
        if (lazyParseablePsiElement == null || (lazyParseablePsiElement = ((KtLambdaExpression)lazyParseablePsiElement).getBodyExpression()) == null) {
            return;
        }
        LazyParseablePsiElement block = lazyParseablePsiElement;
        AssignmentChecker assignmentChecker = new AssignmentChecker();
        block.acceptChildren(assignmentChecker);
        AssignmentChecker $this$visitCallExpression_u24lambda_u241 = assignmentChecker;
        boolean bl = false;
        if ($this$visitCallExpression_u24lambda_u241.getHasGroup() && $this$visitCallExpression_u24lambda_u241.getHasDescription()) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = expression.getValueArgumentList();
        if (ktValueArgumentList != null) {
            ktElement = ktValueArgumentList;
        } else {
            KtExpression ktExpression = org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt.getCalleeExpressionIfAny(expression);
            Intrinsics.checkNotNull(ktExpression);
            ktElement = ktExpression;
        }
        KtElement highlightEndElement = ktElement;
        AbstractCheck abstractCheck = this;
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, PsiUtilsKt.getStartOffset(psiElement), PsiUtilsKt.getEndOffset(highlightEndElement)), MessageKt.message(arg_0 -> TaskDefinitionsCheck.visitCallExpression$lambda$1$lambda$0($this$visitCallExpression_u24lambda_u241, arg_0)), null, null, 12, null);
    }

    private final boolean isTasksRegisterCall(KtCallExpression expression) {
        String functionName;
        KtExpression ktExpression = org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt.getCalleeExpressionIfAny(expression);
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        String string = functionName = ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null;
        if (!Intrinsics.areEqual(functionName, "register") && !Intrinsics.areEqual(functionName, "create")) {
            return false;
        }
        PsiElement psiElement = expression.getParent();
        KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null) {
            return false;
        }
        KtDotQualifiedExpression parent2 = ktDotQualifiedExpression;
        psiElement = parent2.getReceiverExpression();
        KtNameReferenceExpression ktNameReferenceExpression2 = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
        return Intrinsics.areEqual(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null, "tasks");
    }

    private final KtLambdaArgument getLastArgumentLambdaOrNull(KtCallExpression expression) {
        List<KtValueArgument> list = expression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        KtValueArgument ktValueArgument = CollectionsKt.lastOrNull(list);
        return ktValueArgument instanceof KtLambdaArgument ? (KtLambdaArgument)ktValueArgument : null;
    }

    private static final Unit visitCallExpression$lambda$1$lambda$0(AssignmentChecker $this_with, Message $this$message) {
        Intrinsics.checkNotNullParameter($this$message, "$this$message");
        $this$message.unaryPlus("Define ");
        if (!$this_with.getHasGroup()) {
            $this$message.code("group");
        }
        if (!$this_with.getHasGroup() && !$this_with.getHasDescription()) {
            $this$message.unaryPlus(" and ");
        }
        if (!$this_with.getHasDescription()) {
            $this$message.code("description");
        }
        $this$message.unaryPlus(" for this task");
        return Unit.INSTANCE;
    }
}

