/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.gradle.checks.AndroidReleaseBuildUtilsKt;
import org.sonarsource.kotlin.gradle.checks.CalleeAndLambda;

@Rule(key="S7416")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/AndroidReleaseBuildDebugCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitScriptInitializer", "", "initializer", "Lorg/jetbrains/kotlin/psi/KtScriptInitializer;", "data", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-gradle"})
public final class AndroidReleaseBuildDebugCheck
extends AbstractCheck {
    @Override
    public void visitScriptInitializer(@NotNull KtScriptInitializer initializer, @NotNull KotlinFileContext data2) {
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (AndroidReleaseBuildUtilsKt.isSettingGradleKts(data2.getKtFile())) {
            return;
        }
        Object object = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull(initializer, "android");
        if (object == null || (object = ((CalleeAndLambda)object).getLambda()) == null) {
            return;
        }
        Object androidLambda = object;
        if (AndroidReleaseBuildUtilsKt.getApplicationId((KtFunctionLiteral)androidLambda) == null) {
            return;
        }
        CalleeAndLambda calleeAndLambda = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull((KtElement)androidLambda, "buildTypes");
        if (calleeAndLambda == null) {
            return;
        }
        CalleeAndLambda buildTypes = calleeAndLambda;
        CalleeAndLambda calleeAndLambda2 = AndroidReleaseBuildUtilsKt.getChildCallWithLambdaOrNull(buildTypes.getLambda(), "release");
        if (calleeAndLambda2 == null && (calleeAndLambda2 = AndroidReleaseBuildUtilsKt.getGetByNameCallWithLambdaOrNull((KtElement)androidLambda)) == null) {
            return;
        }
        KtFunctionLiteral releaseLambda = calleeAndLambda2.component2();
        KtBinaryExpression isDebuggableAssignment = AndroidReleaseBuildUtilsKt.getPropertyAssignmentOrNull(releaseLambda, "isDebuggable");
        KtExpression ktExpression = isDebuggableAssignment;
        if (ktExpression != null && (ktExpression = ktExpression.getRight()) != null ? Intrinsics.areEqual(ApiExtensionsKt.predictRuntimeBooleanValue(ktExpression), true) : false) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, data2, (PsiElement)isDebuggableAssignment, "Make sure this debug feature is deactivated before delivering the code in production.", null, null, 12, null);
        }
    }
}

