/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.externalreport.ktlint;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.kotlin.externalreport.ktlint.CheckstyleReportParser;
import org.sonarsource.kotlin.externalreport.ktlint.Finding;
import org.sonarsource.kotlin.externalreport.ktlint.FindingsPerFile;
import org.sonarsource.kotlin.externalreport.ktlint.InvalidReportFormatException;
import org.sonarsource.kotlin.externalreport.ktlint.JsonReportParser;
import org.sonarsource.kotlin.externalreport.ktlint.KtlintRulesDefinition;
import org.sonarsource.kotlin.externalreport.ktlint.ReportImporterKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/sonarsource/kotlin/externalreport/ktlint/ReportImporter;", "", "analysisWarnings", "Lorg/sonar/api/notifications/AnalysisWarnings;", "context", "Lorg/sonar/api/batch/sensor/SensorContext;", "<init>", "(Lorg/sonar/api/notifications/AnalysisWarnings;Lorg/sonar/api/batch/sensor/SensorContext;)V", "getAnalysisWarnings", "()Lorg/sonar/api/notifications/AnalysisWarnings;", "getContext", "()Lorg/sonar/api/batch/sensor/SensorContext;", "importFile", "", "reportFile", "Ljava/io/File;", "importJsonFile", "importExternalIssues", "filePath", "", "linterFindings", "", "Lorg/sonarsource/kotlin/externalreport/ktlint/Finding;", "sonar-kotlin-external-linters"})
public final class ReportImporter {
    @NotNull
    private final AnalysisWarnings analysisWarnings;
    @NotNull
    private final SensorContext context;

    public ReportImporter(@NotNull AnalysisWarnings analysisWarnings, @NotNull SensorContext context) {
        Intrinsics.checkNotNullParameter(analysisWarnings, "analysisWarnings");
        Intrinsics.checkNotNullParameter(context, "context");
        this.analysisWarnings = analysisWarnings;
        this.context = context;
    }

    @NotNull
    public final AnalysisWarnings getAnalysisWarnings() {
        return this.analysisWarnings;
    }

    @NotNull
    public final SensorContext getContext() {
        return this.context;
    }

    public final void importFile(@NotNull File reportFile) {
        Intrinsics.checkNotNullParameter(reportFile, "reportFile");
        String string = FilesKt.getExtension(reportFile);
        if (Intrinsics.areEqual(string, "json")) {
            this.importJsonFile(reportFile);
        } else if (Intrinsics.areEqual(string, "xml")) {
            new CheckstyleReportParser(this.context).importFile(reportFile);
        } else {
            String it = "The ktlint report file '" + reportFile + "' has an unsupported extension/format. Expected 'json' or 'xml', got '" + FilesKt.getExtension(reportFile) + "'.";
            boolean bl = false;
            ReportImporterKt.getLOG().error(it);
            this.analysisWarnings.addUnique(it);
        }
    }

    public final void importJsonFile(@NotNull File reportFile) {
        JsonReportParser jsonReportParser;
        Intrinsics.checkNotNullParameter(reportFile, "reportFile");
        try {
            Path path = reportFile.toPath();
            Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
            JsonReportParser $this$importJsonFile_u24lambda_u241 = jsonReportParser = new JsonReportParser(path);
            boolean bl = false;
            $this$importJsonFile_u24lambda_u241.parse();
        }
        catch (InvalidReportFormatException e2) {
            ReportImporterKt.getLOG().error("No issue information will be saved as the report file '" + reportFile + "' cannot be read. " + e2.getMessage());
            return;
        }
        JsonReportParser parser = jsonReportParser;
        Iterable $this$forEach$iv = parser.getReport();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FindingsPerFile findingsPerFile = (FindingsPerFile)element$iv;
            boolean bl = false;
            String filePath = findingsPerFile.component1();
            List<Finding> linterFindings = findingsPerFile.component2();
            this.importExternalIssues(filePath, linterFindings);
        }
    }

    private final void importExternalIssues(String filePath, List<Finding> linterFindings) {
        FilePredicates predicates = this.context.fileSystem().predicates();
        InputFile inputFile = this.context.fileSystem().inputFile(predicates.or(predicates.hasAbsolutePath(filePath), predicates.hasRelativePath(filePath)));
        if (inputFile == null) {
            ReportImporter $this$importExternalIssues_u24lambda_u243 = this;
            boolean bl = false;
            ReportImporterKt.getLOG().warn("Invalid input file " + filePath);
            return;
        }
        InputFile inputFile2 = inputFile;
        ExternalRuleLoader ruleLoader = KtlintRulesDefinition.Companion.getRULE_LOADER();
        Iterable $this$forEach$iv = linterFindings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NewExternalIssue newExternalIssue;
            String string;
            Finding finding = (Finding)element$iv;
            boolean bl = false;
            int line = finding.component1();
            String message = finding.component3();
            String preliminaryRuleKey = finding.component4();
            if (StringsKt.startsWith$default(preliminaryRuleKey, "experimental:", false, 2, null)) {
                String string2 = preliminaryRuleKey.substring(13);
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            } else {
                string = preliminaryRuleKey;
            }
            String ruleKey = string;
            NewExternalIssue $this$importExternalIssues_u24lambda_u245_u24lambda_u244 = newExternalIssue = this.context.newExternalIssue();
            boolean bl2 = false;
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.type(ruleLoader.ruleType(ruleKey));
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.severity(ruleLoader.ruleSeverity(ruleKey));
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.remediationEffortMinutes(ruleLoader.ruleConstantDebtMinutes(ruleKey));
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.at($this$importExternalIssues_u24lambda_u245_u24lambda_u244.newLocation().message(message).on((InputComponent)inputFile2).at(inputFile2.selectLine(line)));
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.engineId("ktlint");
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.ruleId(ruleKey);
            $this$importExternalIssues_u24lambda_u245_u24lambda_u244.save();
        }
    }
}

