/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;

@Rule(key="S2757")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/WrongAssignmentOperatorCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "Companion", "sonar-kotlin-checks"})
public final class WrongAssignmentOperatorCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<KtSingleValueToken> SUSPICIOUS_UNARY_OPERATORS;

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) {
            return;
        }
        KtExpression ktExpression = expression.getRight();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression rightExpression = ktExpression;
        if (!(rightExpression instanceof KtUnaryExpression) || !CollectionsKt.contains((Iterable)SUSPICIOUS_UNARY_OPERATORS, ((KtUnaryExpression)rightExpression).getOperationToken())) {
            return;
        }
        KtSimpleNameExpression ktSimpleNameExpression = ((KtUnaryExpression)rightExpression).getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
        KtSimpleNameExpression unaryOperation = ktSimpleNameExpression;
        KtExpression ktExpression2 = expression.getLeft();
        Intrinsics.checkNotNull(ktExpression2);
        TextRange leftTextRange = KotlinTextRanges.INSTANCE.textRange(context, ktExpression2);
        TextRange rightTextRange = KotlinTextRanges.INSTANCE.textRange(context, unaryOperation);
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
        TextRange opTextRange = KotlinTextRanges.INSTANCE.textRange(context, ktOperationReferenceExpression);
        if (!WrongAssignmentOperatorCheck.Companion.hasSpacingBetween(opTextRange, rightTextRange) && WrongAssignmentOperatorCheck.Companion.hasSpacingBetween(leftTextRange, opTextRange)) {
            TextRange[] textRangeArray = new TextRange[]{opTextRange, rightTextRange};
            TextRange range = KotlinTextRanges.INSTANCE.merge(context, (Iterable<? extends TextRange>)CollectionsKt.listOf(textRangeArray));
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, range, WrongAssignmentOperatorCheck.Companion.getMessage((KtUnaryExpression)rightExpression), null, null, 12, null);
        }
    }

    static {
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.EXCL, KtTokens.PLUS, KtTokens.MINUS};
        SUSPICIOUS_UNARY_OPERATORS = CollectionsKt.listOf(ktSingleValueTokenArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/WrongAssignmentOperatorCheck$Companion;", "", "<init>", "()V", "SUSPICIOUS_UNARY_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "getMessage", "", "expression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "hasSpacingBetween", "", "firstToken", "Lorg/sonar/api/batch/fs/TextRange;", "secondToken", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final String getMessage(KtUnaryExpression expression) {
            return Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EXCL) ? "Add a space between \"=\" and \"!\" to avoid confusion." : "Was \"" + expression.getOperationReference().getText() + "=\" meant instead?";
        }

        private final boolean hasSpacingBetween(TextRange firstToken, TextRange secondToken) {
            return firstToken.end().line() != secondToken.start().line() || firstToken.end().lineOffset() != secondToken.start().lineOffset();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

