/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.WebViewJavaScriptSupportCheckKt;

@Rule(key="S6362")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u001a\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/sonarsource/kotlin/checks/WebViewJavaScriptSupportCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "ctx", "checkJavaScriptEnabledArgument", "argument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "sonar-kotlin-checks"})
public final class WebViewJavaScriptSupportCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit = CollectionsKt.listOf(WebViewJavaScriptSupportCheckKt.access$getANDROID_SET_JAVASCRIPT_ENABLED$p());

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.checkJavaScriptEnabledArgument(kotlinFileContext, ApiExtensionsKt.getFirstArgumentExpression(resolvedCall2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitBinaryExpression_u24lambda_u240 = kaSession;
        boolean bl = false;
        if (Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) {
            KaCallableMemberCall kaCallableMemberCall;
            FunMatcherImpl funMatcherImpl = WebViewJavaScriptSupportCheckKt.access$getANDROID_SET_JAVASCRIPT_ENABLED$p();
            KaCallInfo kaCallInfo = $this$visitBinaryExpression_u24lambda_u240.resolveToCall(expression);
            if (kaCallInfo != null) {
                Object v3;
                FunMatcherImpl funMatcherImpl2;
                block6: {
                    void $this$singleCallOrNull$iv;
                    KaCallInfo kaCallInfo2 = kaCallInfo;
                    funMatcherImpl2 = funMatcherImpl;
                    boolean $i$f$singleCallOrNull = false;
                    Iterable $this$singleOrNull$iv$iv = KaCallInfoKt.getCalls((KaCallInfo)$this$singleCallOrNull$iv);
                    boolean $i$f$singleOrNull = false;
                    Object single$iv$iv = null;
                    boolean found$iv$iv = false;
                    for (Object element$iv$iv : $this$singleOrNull$iv$iv) {
                        KaCall it$iv = (KaCall)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it$iv instanceof KaCallableMemberCall)) continue;
                        if (found$iv$iv) {
                            v3 = null;
                            break block6;
                        }
                        single$iv$iv = element$iv$iv;
                        found$iv$iv = true;
                    }
                    v3 = !found$iv$iv ? null : single$iv$iv;
                }
                funMatcherImpl = funMatcherImpl2;
                kaCallableMemberCall = (KaCallableMemberCall)((KaCall)v3);
            } else {
                kaCallableMemberCall = null;
            }
            if (funMatcherImpl.matches(kaCallableMemberCall)) {
                this.checkJavaScriptEnabledArgument(ctx, expression.getRight());
            }
        }
    }

    private final void checkJavaScriptEnabledArgument(KotlinFileContext ctx, KtExpression argument) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$checkJavaScriptEnabledArgument_u24lambda_u241 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = argument;
        if (ktExpression != null ? Intrinsics.areEqual(ApiExtensionsKt.predictRuntimeBooleanValue(ktExpression), true) : false) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)argument, "Make sure that enabling JavaScript support is safe here.", null, null, 12, null);
        }
    }
}

