/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S4423")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0006*\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/sonarsource/kotlin/checks/WeakSSLContextCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "WEAK_FOR_OK_HTTP", "", "", "WEAK_FOR_SSL", "OKHTTP_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "SSL_CONTEXT_MATCHER", "visitCallExpression", "", "node", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "handleSSL", "handleOkHttp", "reportUnsecureSSLContext", "unsecureVersions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "value", "sonar-kotlin-checks"})
public final class WeakSSLContextCheck
extends AbstractCheck {
    @NotNull
    private final Set<String> WEAK_FOR_OK_HTTP;
    @NotNull
    private final Set<String> WEAK_FOR_SSL;
    @NotNull
    private final FunMatcherImpl OKHTTP_MATCHER;
    @NotNull
    private final FunMatcherImpl SSL_CONTEXT_MATCHER;

    public WeakSSLContextCheck() {
        String[] stringArray = new String[]{"TLSv1", "TLSv1.1", "TLS_1_0", "TLS_1_1", "okhttp3.TlsVersion.TLS_1_0", "okhttp3.TlsVersion.TLS_1_1"};
        this.WEAK_FOR_OK_HTTP = SetsKt.setOf(stringArray);
        stringArray = new String[]{"SSL", "TLS", "DTLS", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "DTLSv1.0"};
        this.WEAK_FOR_SSL = SetsKt.setOf(stringArray);
        this.OKHTTP_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, WeakSSLContextCheck::OKHTTP_MATCHER$lambda$0, 1023, null);
        this.SSL_CONTEXT_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, WeakSSLContextCheck::SSL_CONTEXT_MATCHER$lambda$1, 1023, null);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression node, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (this.SSL_CONTEXT_MATCHER.matches(node)) {
            this.handleSSL(node, kotlinFileContext);
        } else if (this.OKHTTP_MATCHER.matches(node)) {
            this.handleOkHttp(node, kotlinFileContext);
        }
    }

    private final void handleSSL(KtCallExpression node, KotlinFileContext kotlinFileContext) {
        block1: {
            KtExpression ktExpression;
            List<KtValueArgument> list = node.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list);
            if (ktValueArgument == null || (ktExpression = ktValueArgument.getArgumentExpression()) == null) break block1;
            KtExpression it = ktExpression;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)this.WEAK_FOR_SSL, this.value(it))) {
                this.reportUnsecureSSLContext(CollectionsKt.listOf(it), kotlinFileContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleOkHttp(KtCallExpression node, KotlinFileContext kotlinFileContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        List<KtValueArgument> list = node.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl2 = false;
            if (it.getArgumentExpression() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)this.WEAK_FOR_OK_HTTP, this.value(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsecureVersions = (List)destination$iv$iv;
        this.reportUnsecureSSLContext(unsecureVersions, kotlinFileContext);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportUnsecureSSLContext(List<? extends KtExpression> unsecureVersions, KotlinFileContext kotlinFileContext) {
        if (!((Collection)unsecureVersions).isEmpty()) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<KtExpression> secondaries = CollectionsKt.minus((Iterable)unsecureVersions, unsecureVersions.get(0));
            Iterable iterable = secondaries;
            String string = "Change this code to use a stronger protocol.";
            PsiElement psiElement = unsecureVersions.get(0);
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)it), "Other weak protocol."));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement, string, (List)collection, null, 8, null);
        }
    }

    private final String value(KtExpression $this$value) {
        String string;
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$value_u24lambda_u246 = kaSession;
        boolean bl = false;
        KtExpression ktExpression = $this$value;
        if (ktExpression instanceof KtStringTemplateExpression) {
            string = this.asConstant((KtStringTemplateExpression)$this$value);
        } else if (ktExpression instanceof KtNameReferenceExpression) {
            string = ApiExtensionsKt.predictRuntimeStringValue($this$value);
        } else if (ktExpression instanceof KtDotQualifiedExpression) {
            FqName fqName2;
            KaEnumEntrySymbol kaEnumEntrySymbol;
            Object object = ((KtDotQualifiedExpression)$this$value).getSelectorExpression();
            Object object2 = object != null && (object = ReferenceUtilsKt.getMainReference((KtElement)object)) != null ? $this$value_u24lambda_u246.resolveToSymbol((KtReference)object) : null;
            KaEnumEntrySymbol kaEnumEntrySymbol2 = kaEnumEntrySymbol = object2 instanceof KaEnumEntrySymbol ? (KaEnumEntrySymbol)object2 : null;
            string = kaEnumEntrySymbol != null && (object2 = kaEnumEntrySymbol.getCallableId()) != null && (fqName2 = ((CallableId)object2).asSingleFqName()) != null ? fqName2.asString() : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final Unit OKHTTP_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("okhttp3.ConnectionSpec.Builder");
        $this$FunMatcher.setName("tlsVersions");
        return Unit.INSTANCE;
    }

    private static final Unit SSL_CONTEXT_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.net.ssl.SSLContext");
        $this$FunMatcher.setName("getInstance");
        return Unit.INSTANCE;
    }
}

