/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S5527")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitLambdaExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "onlyReturnsTrue", "", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isTrueConstant", "Companion", "sonar-kotlin-checks"})
public final class VerifiedServerHostnamesCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FunMatcherImpl VERIFY_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, VerifiedServerHostnamesCheck::VERIFY_MATCHER$lambda$2, 1023, null);
    @NotNull
    private static final FunMatcherImpl HOSTNAME_VERIFIER_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, VerifiedServerHostnamesCheck::HOSTNAME_VERIFIER_MATCHER$lambda$3, 1023, null);
    @NotNull
    public static final String MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        List<KtExpression> listStatements;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (VERIFY_MATCHER.matches(function2) && (listStatements = this.listStatements(function2)).size() == 1 && this.onlyReturnsTrue(listStatements.get(0))) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = function2.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, MESSAGE, null, null, 12, null);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        block3: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            KaFunctionCall<?> kaFunctionCall = ApiExtensionsKt.getParentCall(expression);
            if (kaFunctionCall == null) break block3;
            KaFunctionCall<?> it = kaFunctionCall;
            boolean bl = false;
            if (HOSTNAME_VERIFIER_MATCHER.matches((KaCallableMemberCall)it)) {
                List<KtExpression> listStatements;
                KtBlockExpression ktBlockExpression = expression.getBodyExpression();
                List<KtExpression> list = listStatements = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
                boolean bl2 = list != null ? list.size() == 1 : false;
                if (bl2) {
                    KtExpression ktExpression = listStatements.get(0);
                    Intrinsics.checkNotNullExpressionValue(ktExpression, "get(...)");
                    if (this.isTrueConstant(ktExpression)) {
                        AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, MESSAGE, null, null, 12, null);
                    }
                }
            }
        }
    }

    private final boolean onlyReturnsTrue(KtExpression ktExpression) {
        boolean bl;
        if (ktExpression instanceof KtReturnExpression) {
            KtExpression ktExpression2 = ((KtReturnExpression)ktExpression).getReturnedExpression();
            bl = ktExpression2 != null ? this.isTrueConstant(ktExpression2) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isTrueConstant(KtExpression $this$isTrueConstant) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$isTrueConstant_u24lambda_u241 = kaSession;
        boolean bl = false;
        Boolean bl2 = ApiExtensionsKt.predictRuntimeBooleanValue($this$isTrueConstant);
        return bl2 != null ? bl2 : false;
    }

    private static final Unit VERIFY_MATCHER$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setDefiningSupertype("javax.net.ssl.HostnameVerifier");
        $this$FunMatcher.setName("verify");
        return Unit.INSTANCE;
    }

    private static final Unit HOSTNAME_VERIFIER_MATCHER$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("okhttp3.OkHttpClient.Builder");
        $this$FunMatcher.setName("hostnameVerifier");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/VerifiedServerHostnamesCheck$Companion;", "", "<init>", "()V", "VERIFY_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getVERIFY_MATCHER", "()Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "HOSTNAME_VERIFIER_MATCHER", "getHOSTNAME_VERIFIER_MATCHER", "MESSAGE", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FunMatcherImpl getVERIFY_MATCHER() {
            return VERIFY_MATCHER;
        }

        @NotNull
        public final FunMatcherImpl getHOSTNAME_VERIFIER_MATCHER() {
            return HOSTNAME_VERIFIER_MATCHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

