/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S117")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/sonarsource/kotlin/checks/VariableAndParameterNameCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "format", "", "getFormat", "()Ljava/lang/String;", "setFormat", "(Ljava/lang/String;)V", "formatRegex", "Lkotlin/text/Regex;", "initialize", "", "ruleKey", "Lorg/sonar/api/rule/RuleKey;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitLambdaExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "check", "kind", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Companion", "sonar-kotlin-checks"})
public final class VariableAndParameterNameCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="format", description="Regular expression used to check the names against.", defaultValue="^`?[_a-z][a-zA-Z0-9]*`?$")
    @NotNull
    private String format = "^`?[_a-z][a-zA-Z0-9]*`?$";
    private Regex formatRegex;
    @NotNull
    public static final String DEFAULT_FORMAT = "^`?[_a-z][a-zA-Z0-9]*`?$";

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.format = string;
    }

    @Override
    public void initialize(@NotNull RuleKey ruleKey) {
        Intrinsics.checkNotNullParameter(ruleKey, "ruleKey");
        super.initialize(ruleKey);
        this.formatRegex = new Regex(this.format);
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        Iterable $this$forEach$iv = constructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.check("parameter", it, kotlinFileContext);
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (property.isLocal()) {
            this.check("local variable", property, kotlinFileContext);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        List<KtParameter> list = expression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.check("parameter", it, kotlinFileContext);
        }
    }

    private final void check(String kind, KtNamedDeclaration declaration, KotlinFileContext kotlinFileContext) {
        Object object = declaration.getNameIdentifier();
        if (object == null || (object = object.getText()) == null) {
            return;
        }
        Object name = object;
        CharSequence charSequence = (CharSequence)name;
        Regex regex = this.formatRegex;
        if (regex == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatRegex");
            regex = null;
        }
        if (!regex.matches(charSequence)) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = declaration.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, psiElement, "Rename this " + kind + " to match the regular expression " + this.format, null, null, 12, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/VariableAndParameterNameCheck$Companion;", "", "<init>", "()V", "DEFAULT_FORMAT", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

