/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.UselessNullCheckCheckKt;

@Rule(key="S6619")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\tH\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0007H\u0002JA\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050\u001d\u00a2\u0006\u0002\b\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/sonarsource/kotlin/checks/UselessNullCheckCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitBinaryExpression", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitSafeQualifiedExpression", "safeDotExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "kfc", "visitUnaryExpression", "unaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitCallExpression", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "operandComparedToNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "raiseIssueIfUselessCheck", "expression", "issueLocation", "Lcom/intellij/psi/PsiElement;", "comparesToNull", "", "nullCheckTypeForMessage", "Lkotlin/Function1;", "Lorg/sonarsource/kotlin/api/reporting/Message;", "Lkotlin/ExtensionFunctionType;", "sonar-kotlin-checks"})
public final class UselessNullCheckCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(binaryExpression, "binaryExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        IElementType iElementType = binaryExpression.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.raiseIssueIfUselessCheck(kotlinFileContext, it, binaryExpression, true, UselessNullCheckCheck::visitBinaryExpression$lambda$1$lambda$0);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.raiseIssueIfUselessCheck(kotlinFileContext, it, binaryExpression, false, UselessNullCheckCheck::visitBinaryExpression$lambda$3$lambda$2);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.ELVIS)) {
            KtExpression ktExpression = binaryExpression.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            this.raiseIssueIfUselessCheck(kotlinFileContext, ktExpression, ktOperationReferenceExpression, false, UselessNullCheckCheck::visitBinaryExpression$lambda$4);
        }
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression safeDotExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(safeDotExpression, "safeDotExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        KtExpression ktExpression = safeDotExpression.getReceiverExpression();
        PsiElement psiElement = safeDotExpression.getOperationTokenNode().getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        this.raiseIssueIfUselessCheck(kfc, ktExpression, psiElement, false, UselessNullCheckCheck::visitSafeQualifiedExpression$lambda$5);
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression unaryExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(unaryExpression, "unaryExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        if (Intrinsics.areEqual(unaryExpression.getOperationToken(), KtTokens.EXCLEXCL)) {
            KtExpression ktExpression = unaryExpression.getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtSimpleNameExpression ktSimpleNameExpression = unaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            this.raiseIssueIfUselessCheck(kfc, ktExpression, ktSimpleNameExpression, false, UselessNullCheckCheck::visitUnaryExpression$lambda$6);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitCallExpression_u24lambda_u247 = kaSession;
        boolean bl = false;
        KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u247.resolveToCall(callExpression);
        KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
        if (kaFunctionCall == null) {
            return;
        }
        KaFunctionCall<?> resolvedCall2 = kaFunctionCall;
        if (FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, UselessNullCheckCheckKt.access$getNON_NULL_CHECK_FUNS$p())) {
            KtExpression argExpression = (KtExpression)CollectionsKt.first((Iterable)resolvedCall2.getArgumentMapping().keySet());
            this.raiseIssueIfUselessCheck(kfc, argExpression, callExpression, false, arg_0 -> UselessNullCheckCheck.visitCallExpression$lambda$8(resolvedCall2, arg_0));
        }
    }

    private final KtExpression operandComparedToNull(KtBinaryExpression $this$operandComparedToNull) {
        KtExpression ktExpression = $this$operandComparedToNull.getLeft();
        if (ktExpression == null || (ktExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression, null, 1, null)) == null) {
            return null;
        }
        KtExpression leftResolved = ktExpression;
        KtExpression ktExpression2 = $this$operandComparedToNull.getRight();
        if (ktExpression2 == null || (ktExpression2 = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression2, null, 1, null)) == null) {
            return null;
        }
        KtExpression rightResolved = ktExpression2;
        return PsiUtilsKt.isNull(leftResolved) ? $this$operandComparedToNull.getRight() : (PsiUtilsKt.isNull(rightResolved) ? $this$operandComparedToNull.getLeft() : null);
    }

    private final void raiseIssueIfUselessCheck(KotlinFileContext kfc, KtExpression expression, PsiElement issueLocation, boolean comparesToNull, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        String string;
        KtExpression resolvedExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(expression, null, 1, null);
        if (PsiUtilsKt.isNull(resolvedExpression)) {
            string = comparesToNull ? "succeeds" : "fails";
        } else if (UselessNullCheckCheckKt.access$isNotNullable(expression)) {
            string = comparesToNull ? "fails" : "succeeds";
        } else {
            return;
        }
        String result2 = string;
        AbstractCheck.reportIssue$default((AbstractCheck)this, kfc, issueLocation, null, null, arg_0 -> UselessNullCheckCheck.raiseIssueIfUselessCheck$lambda$9(nullCheckTypeForMessage, result2, arg_0), 6, null);
    }

    private static final Unit visitBinaryExpression$lambda$1$lambda$0(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$3$lambda$2(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null check");
        return Unit.INSTANCE;
    }

    private static final Unit visitBinaryExpression$lambda$4(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("elvis operation ");
        $this$raiseIssueIfUselessCheck.code("?:");
        return Unit.INSTANCE;
    }

    private static final Unit visitSafeQualifiedExpression$lambda$5(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("null-safe access ");
        $this$raiseIssueIfUselessCheck.code("?.");
        return Unit.INSTANCE;
    }

    private static final Unit visitUnaryExpression$lambda$6(Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null assertion ");
        $this$raiseIssueIfUselessCheck.code("!!");
        return Unit.INSTANCE;
    }

    private static final Unit visitCallExpression$lambda$8(KaFunctionCall $resolvedCall, Message $this$raiseIssueIfUselessCheck) {
        Intrinsics.checkNotNullParameter($this$raiseIssueIfUselessCheck, "$this$raiseIssueIfUselessCheck");
        $this$raiseIssueIfUselessCheck.unaryPlus("non-null check ");
        $this$raiseIssueIfUselessCheck.code(String.valueOf(KaSymbolKt.getName((KaSymbol)KaPartiallyAppliedSymbolKt.getSymbol($resolvedCall.getPartiallyAppliedSymbol()))));
        return Unit.INSTANCE;
    }

    private static final Unit raiseIssueIfUselessCheck$lambda$9(Function1 $nullCheckTypeForMessage, String $result, Message $this$reportIssue) {
        Intrinsics.checkNotNullParameter($this$reportIssue, "$this$reportIssue");
        $this$reportIssue.unaryPlus("Remove this useless ");
        $nullCheckTypeForMessage.invoke($this$reportIssue);
        $this$reportIssue.unaryPlus(", it always " + $result + ".");
        return Unit.INSTANCE;
    }
}

