/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.UselessIncrementCheckKt;

@Rule(key="S2123")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/UselessIncrementCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitReturnExpression", "", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "asPostfixIncrement", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "matchSameNameReference", "", "a", "b", "sonar-kotlin-checks"})
public final class UselessIncrementCheck
extends AbstractCheck {
    @Override
    public void visitReturnExpression(@NotNull KtReturnExpression returnExpression, @NotNull KotlinFileContext ctx) {
        block1: {
            Intrinsics.checkNotNullParameter(returnExpression, "returnExpression");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            KtPostfixExpression ktPostfixExpression = this.asPostfixIncrement(returnExpression.getReturnedExpression());
            if (ktPostfixExpression == null) break block1;
            KtPostfixExpression it = ktPostfixExpression;
            boolean bl = false;
            if (ApiExtensionsKt.isLocalVariable(it.getBaseExpression())) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)it, "Remove this increment or correct the code not to waste it.", null, null, 12, null);
            }
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext ctx) {
        block2: {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(ctx, "ctx");
            if (!Intrinsics.areEqual(expression.getOperationToken(), KtTokens.EQ)) break block2;
            KtPostfixExpression ktPostfixExpression = this.asPostfixIncrement(expression.getRight());
            if (ktPostfixExpression != null) {
                KtPostfixExpression it = ktPostfixExpression;
                boolean bl = false;
                if (this.matchSameNameReference(expression.getLeft(), it.getBaseExpression())) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, (PsiElement)expression, "Remove this increment or correct the code not to waste it.", null, null, 12, null);
                }
            }
        }
    }

    private final KtPostfixExpression asPostfixIncrement(KtExpression $this$asPostfixIncrement) {
        return $this$asPostfixIncrement instanceof KtPostfixExpression && CollectionsKt.contains(UselessIncrementCheckKt.access$getPOSTFIX_INCREMENT_OPERATORS$p(), ((KtPostfixExpression)$this$asPostfixIncrement).getOperationToken()) ? (KtPostfixExpression)$this$asPostfixIncrement : null;
    }

    private final boolean matchSameNameReference(KtExpression a2, KtExpression b2) {
        return a2 instanceof KtNameReferenceExpression && b2 instanceof KtNameReferenceExpression && Intrinsics.areEqual(((KtNameReferenceExpression)a2).getReferencedName(), ((KtNameReferenceExpression)b2).getReferencedName());
    }
}

