/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;

@Rule(key="S6615")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/UselessAssignmentsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class UselessAssignmentsCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        Sequence<Pair> $this$forEach$iv = SequencesKt.mapNotNull(context.getKaDiagnostics(), UselessAssignmentsCheck::visitKtFile$lambda$1);
        boolean $i$f$forEach = false;
        Iterator<Pair> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Pair element$iv;
            Pair pair = element$iv = iterator2.next();
            boolean bl = false;
            PsiElement element = (PsiElement)pair.component1();
            String msg = (String)pair.component2();
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, element, msg, null, null, 12, null);
        }
    }

    private static final Pair visitKtFile$lambda$1(KaDiagnosticWithPsi diagnostic) {
        Pair<Object, String> pair;
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        String string = diagnostic.getFactoryName();
        if (Intrinsics.areEqual(string, FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT().getName())) {
            pair = TuplesKt.to(diagnostic.getPsi(), "Remove this useless initializer.");
        } else if (Intrinsics.areEqual(string, FirErrors.INSTANCE.getVARIABLE_NEVER_READ().getName())) {
            Object PSI = diagnostic.getPsi();
            Intrinsics.checkNotNull(PSI, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            PsiElement psiElement = ((KtNamedDeclaration)PSI).getIdentifyingElement();
            Intrinsics.checkNotNull(psiElement);
            pair = TuplesKt.to(psiElement, "Remove this variable, which is assigned but never accessed.");
        } else if (Intrinsics.areEqual(string, FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ().getName())) {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$visitKtFile_u24lambda_u241_u24lambda_u240 = kaSession;
            boolean bl = false;
            PsiElement psiElement = diagnostic.getPsi().getParent();
            KtPrefixExpression ktPrefixExpression = psiElement instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement : null;
            boolean bl2 = ktPrefixExpression != null ? $this$visitKtFile_u24lambda_u241_u24lambda_u240.isUsedAsExpression(ktPrefixExpression) : false;
            if (bl2) {
                return null;
            }
            pair = TuplesKt.to(diagnostic.getPsi().getParent(), "The value assigned here is never used.");
        } else {
            pair = null;
        }
        return pair;
    }
}

