/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.UnusedPrivateMethodCheckKt;

@Rule(key="S1144")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/UnusedPrivateMethodCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isReferencedIn", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "name", "", "hasReferences", "hasInfixReferences", "shouldCheckForUsage", "annotatedWithCommonAnnotations", "sonar-kotlin-checks"})
public final class UnusedPrivateMethodCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext context) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!klass.isTopLevel()) {
            return;
        }
        PsiElement psiElement = klass;
        Function1<KtNamedFunction, Boolean> predicate$iv = arg_0 -> UnusedPrivateMethodCheck.visitClass$lambda$0(this, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var8_11 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var11_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtNamedFunction, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtNamedFunction) {
                    this.$action.invoke(element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String functionName;
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it.getName());
            if (UnusedPrivateMethodCheckKt.access$getIGNORED_METHODS$p().contains(functionName) || this.isReferencedIn(it, klass, functionName)) continue;
            AbstractCheck abstractCheck = this;
            PsiElement psiElement2 = it.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement2);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement2, "Remove this unused private \"" + functionName + "\" method.", null, null, 12, null);
        }
    }

    private final boolean isReferencedIn(KtNamedFunction $this$isReferencedIn, KtClass klass, String name) {
        return this.hasReferences(klass, name) || ApiExtensionsKt.isInfix($this$isReferencedIn) && this.hasInfixReferences(klass, name);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasReferences(KtClass $this$hasReferences, String name) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = $this$hasReferences;
        Function1<KtNameReferenceExpression, Boolean> predicate$iv = arg_0 -> UnusedPrivateMethodCheck.hasReferences$lambda$2(name, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInfixReferences(KtClass $this$hasInfixReferences, String name) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = $this$hasInfixReferences;
        Function1<KtOperationReferenceExpression, Boolean> predicate$iv = arg_0 -> UnusedPrivateMethodCheck.hasInfixReferences$lambda$3(name, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtOperationReferenceExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean shouldCheckForUsage(KtNamedFunction $this$shouldCheckForUsage) {
        return KtPsiUtilKt.isPrivate($this$shouldCheckForUsage) && !$this$shouldCheckForUsage.hasModifier(KtTokens.OPERATOR_KEYWORD) && ($this$shouldCheckForUsage.getAnnotationEntries().isEmpty() || this.annotatedWithCommonAnnotations($this$shouldCheckForUsage));
    }

    private final boolean annotatedWithCommonAnnotations(KtNamedFunction $this$annotatedWithCommonAnnotations) {
        boolean bl;
        block3: {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$annotatedWithCommonAnnotations_u24lambda_u245 = kaSession;
            boolean bl2 = false;
            Iterable $this$all$iv = $this$annotatedWithCommonAnnotations_u24lambda_u245.getSymbol($this$annotatedWithCommonAnnotations).getAnnotations();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KaAnnotation it = (KaAnnotation)element$iv;
                    boolean bl3 = false;
                    ClassId classId = it.getClassId();
                    if (CollectionsKt.contains(UnusedPrivateMethodCheckKt.access$getCOMMON_ANNOTATIONS$p(), classId != null ? classId.asFqNameString() : null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean visitClass$lambda$0(UnusedPrivateMethodCheck this$0, KtNamedFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.shouldCheckForUsage(it);
    }

    private static final boolean hasReferences$lambda$2(String $name, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getReferencedName(), $name);
    }

    private static final boolean hasInfixReferences$lambda$3(String $name, KtOperationReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getReferencedName(), $name);
    }
}

