/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.UnusedFunctionParameterCheckKt;

@Rule(key="S1172")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/UnusedFunctionParameterCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitLambdaExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "reportUnusedParameters", "unusedParameters", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "singleMessage", "", "pluralMessage", "sonar-kotlin-checks"})
public final class UnusedFunctionParameterCheck
extends AbstractCheck {
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!UnusedFunctionParameterCheckKt.access$shouldBeChecked(function2)) {
            return;
        }
        List unusedParameters = UnusedFunctionParameterCheckKt.access$getUnusedParameters(function2);
        String singleMessage = function2.isAnonymous() ? "Use \"_\" instead of this unused function parameter" : "Remove this unused function parameter";
        String pluralMessage = function2.isAnonymous() ? "Use \"_\" instead of these unused function parameters." : "Remove these unused function parameters.";
        if (!((Collection)unusedParameters).isEmpty()) {
            this.reportUnusedParameters(context, unusedParameters, singleMessage, pluralMessage);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        List unusedParameters = UnusedFunctionParameterCheckKt.access$getUnusedParameters(expression);
        String singleMessage = "Use \"_\" instead of this unused lambda parameter";
        String pluralMessage = "Use \"_\" instead of these unused lambda parameters.";
        if (!((Collection)unusedParameters).isEmpty()) {
            this.reportUnusedParameters(context, unusedParameters, singleMessage, pluralMessage);
        }
    }

    private final void reportUnusedParameters(KotlinFileContext context, List<? extends KtNamedDeclaration> unusedParameters, String singleMessage, String pluralMessage) {
        KtNamedDeclaration firstUnused = unusedParameters.get(0);
        List<SecondaryLocation> secondaryLocations = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence((Iterable)unusedParameters), arg_0 -> UnusedFunctionParameterCheck.reportUnusedParameters$lambda$0(context, singleMessage, arg_0)));
        if (unusedParameters.size() > 1) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = firstUnused.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, pluralMessage, secondaryLocations, null, 8, null);
        } else {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = firstUnused.getNameIdentifier();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, singleMessage + " \"" + firstUnused.getName() + "\".", null, null, 12, null);
        }
    }

    private static final SecondaryLocation reportUnusedParameters$lambda$0(KotlinFileContext $context, String $singleMessage, KtNamedDeclaration unusedParameter) {
        Intrinsics.checkNotNullParameter(unusedParameter, "unusedParameter");
        PsiElement psiElement = unusedParameter.getNameIdentifier();
        Intrinsics.checkNotNull(psiElement);
        return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange($context, psiElement), $singleMessage + " \"" + unusedParameter.getName() + "\".");
    }
}

