/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.CommonConstantsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.UnpredictableHashSaltCheckKt;

@Rule(key="S2053")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/UnpredictableHashSaltCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/Set;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "matchedFun", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "byteArrayInitSizeTooSmall", "", "sonar-kotlin-checks"})
public final class UnpredictableHashSaltCheck
extends CallAbstractCheck {
    @NotNull
    private final Set<FunMatcherImpl> functionsToVisit = UnpredictableHashSaltCheckKt.access$getMatcherSaltIndexMap$p().keySet();

    @NotNull
    public Set<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull FunMatcherImpl matchedFun, @NotNull KotlinFileContext kotlinFileContext) {
        KaFunctionCall<?> kaFunctionCall;
        KtExpression predictedSaltValue;
        KtExpression saltArg;
        block9: {
            block8: {
                KaFunctionCall<?> kaFunctionCall2;
                KaFunctionCall<?> kaFunctionCall3;
                Intrinsics.checkNotNullParameter(callExpression, "callExpression");
                Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
                Intrinsics.checkNotNullParameter(matchedFun, "matchedFun");
                Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
                boolean $i$f$withKaSession = false;
                KaSession kaSession = KotlinFileVisitorKt.getKaSession();
                Intrinsics.checkNotNull(kaSession);
                KaSession $this$visitFunctionCall_u24lambda_u241 = kaSession;
                boolean bl = false;
                Object v2 = UnpredictableHashSaltCheckKt.access$getMatcherSaltIndexMap$p().get(matchedFun);
                Intrinsics.checkNotNull(v2);
                int saltArgIndex = ((Number)v2).intValue();
                if (callExpression.getValueArguments().size() < 2) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)callExpression, "Add an unpredictable salt value to this hash.", null, null, 12, null);
                    return;
                }
                KtExpression ktExpression = (KtExpression)CollectionsKt.elementAtOrNull((Iterable)resolvedCall2.getArgumentMapping().keySet(), saltArgIndex);
                if (ktExpression == null) {
                    return;
                }
                saltArg = ktExpression;
                predictedSaltValue = ApiExtensionsKt.predictRuntimeValueExpression$default(saltArg, null, 1, null);
                if (ApiExtensionsKt.isBytesInitializedFromString(predictedSaltValue)) {
                    AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt unpredictable.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, predictedSaltValue, "Predictable salt value")), null, 8, null);
                    return;
                }
                KaCallInfo kaCallInfo = $this$visitFunctionCall_u24lambda_u241.resolveToCall(predictedSaltValue);
                if (kaCallInfo == null || (kaFunctionCall3 = KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo)) == null) break block8;
                KaFunctionCall<?> it = kaFunctionCall2 = kaFunctionCall3;
                boolean bl2 = false;
                KaFunctionCall<Object> kaFunctionCall4 = kaFunctionCall = FunMatcherKt.matches((KaCallableMemberCall)it, CommonConstantsKt.getBYTE_ARRAY_CONSTRUCTOR()) ? kaFunctionCall2 : null;
                if (kaFunctionCall != null) break block9;
            }
            return;
        }
        KaFunctionCall<?> saltInitializer = kaFunctionCall;
        if (this.byteArrayInitSizeTooSmall(saltInitializer)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt at least 16 bytes.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf$default(kotlinFileContext, predictedSaltValue, null, 2, null)), null, 8, null);
        }
        if (FunMatcherKt.matches((KaCallableMemberCall)saltInitializer, CommonConstantsKt.getBYTE_ARRAY_CONSTRUCTOR_SIZE_ARG_ONLY()) && ApiExtensionsKt.isInitializedPredictably(saltArg, predictedSaltValue)) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)saltArg, "Make this salt unpredictable.", CollectionsKt.listOf(KotlinFileContextKt.secondaryOf(kotlinFileContext, predictedSaltValue, "Predictable salt value")), null, 8, null);
        }
    }

    private final boolean byteArrayInitSizeTooSmall(KaFunctionCall<?> $this$byteArrayInitSizeTooSmall) {
        Object object = ApiExtensionsKt.getFirstArgumentExpression($this$byteArrayInitSizeTooSmall);
        return (object != null && (object = ApiExtensionsKt.predictRuntimeIntValue((KtExpression)object)) != null ? (Integer)object : 16) < 16;
    }
}

