/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S103")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLineCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "maximumLineLength", "", "getMaximumLineLength", "()I", "setMaximumLineLength", "(I)V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "getLineRange", "Lorg/sonar/api/batch/fs/TextRange;", "kotlin.jvm.PlatformType", "inputFile", "Lorg/sonar/api/batch/fs/InputFile;", "lineNumber", "line", "", "Companion", "sonar-kotlin-checks"})
public final class TooLongLineCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="200")
    private int maximumLineLength = 200;
    public static final int DEFAULT_MAXIMUM_LINE_LENGTH = 200;

    public final int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public final void setMaximumLineLength(int n2) {
        this.maximumLineLength = n2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String[] stringArray = new String[]{"\n", "\r\n", "\r"};
        Sequence $this$forEachIndexed$iv = StringsKt.splitToSequence$default((CharSequence)string, stringArray, false, 0, 6, null);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Iterator iterator2 = $this$forEachIndexed$iv.iterator();
        while (iterator2.hasNext()) {
            void line;
            int n2;
            Object item$iv = iterator2.next();
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int lineNumber = n2;
            boolean bl = false;
            if (line.length() <= this.maximumLineLength) continue;
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, this.getLineRange(kotlinFileContext.getInputFileContext().getInputFile(), lineNumber, (String)line), "Split this " + line.length() + " characters long line (which is greater than " + this.maximumLineLength + " authorized).", null, null, 12, null);
        }
    }

    private final TextRange getLineRange(InputFile inputFile, int lineNumber, String line) {
        return inputFile.newRange(inputFile.newPointer(lineNumber + 1, 0), inputFile.newPointer(lineNumber + 1, line.length()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLineCheck$Companion;", "", "<init>", "()V", "DEFAULT_MAXIMUM_LINE_LENGTH", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

