/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.AbstractTooLongFunctionRule;

@Rule(key="S5612")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/TooLongLambdaCheck;", "Lorg/sonarsource/kotlin/checks/AbstractTooLongFunctionRule;", "<init>", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "elementName", "", "getElementName", "()Ljava/lang/String;", "visitLambdaExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class TooLongLambdaCheck
extends AbstractTooLongFunctionRule {
    @RuleProperty(key="max", description="Maximum authorized lines of code in a lambda expression", defaultValue="20")
    private int max = 20;
    @NotNull
    private final String elementName;

    public TooLongLambdaCheck() {
        this.elementName = "lambda";
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int n2) {
        this.max = n2;
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        KtFunctionLiteral ktFunctionLiteral = expression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
        this.check(ktFunctionLiteral, kotlinFileContext);
    }
}

