/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Rule(key="S134")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lorg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "check", "Lorg/jetbrains/kotlin/psi/KtExpression;", "nodeToHighlight", "Lcom/intellij/psi/PsiElement;", "isTernaryOperator", "", "tree", "isElseIfStatement", "parent", "Companion", "sonar-kotlin-checks"})
public final class TooDeeplyNestedStatementsCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth", defaultValue="3")
    private int max = 3;
    public static final int DEFAULT_MAX_DEPTH = 3;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n2) {
        this.max = n2;
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression, kotlinFileContext);
    }

    @Override
    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(loopExpression, kotlinFileContext);
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression, kotlinFileContext);
    }

    @Override
    public void visitTryExpression(@NotNull KtTryExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        this.check(expression, kotlinFileContext);
    }

    /*
     * WARNING - void declaration
     */
    private final void check(KtExpression expression, KotlinFileContext kotlinFileContext) {
        Object parent2;
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        if (this.isElseIfStatement(psiElement, expression)) {
            return;
        }
        if (this.isTernaryOperator(expression)) {
            return;
        }
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParents(expression).iterator();
        List nestedParentNodes = new ArrayList();
        Object last2 = expression;
        while (iterator2.hasNext()) {
            parent2 = iterator2.next();
            if (this.isElseIfStatement((PsiElement)parent2, (PsiElement)last2) && !((Collection)nestedParentNodes).isEmpty()) {
                CollectionsKt.removeLast(nestedParentNodes);
            }
            if (parent2 instanceof KtLoopExpression || parent2 instanceof KtTryExpression || parent2 instanceof KtIfExpression || parent2 instanceof KtWhenExpression) {
                nestedParentNodes.add((KtExpression)parent2);
            }
            if (nestedParentNodes.size() > this.max) {
                return;
            }
            last2 = parent2;
        }
        if (nestedParentNodes.size() == this.max) {
            Collection<SecondaryLocation> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            parent2 = nestedParentNodes;
            String string = "Refactor this code to not nest more than " + this.max + " control flow statements.";
            PsiElement psiElement2 = this.nodeToHighlight(expression);
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$mapIndexed = false;
            void var8_12 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                void psiElement3;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, this.nodeToHighlight((KtExpression)psiElement3)), "Nesting depth " + (int)i2));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement2, string, (List)collection, null, 8, null);
        }
    }

    private final PsiElement nodeToHighlight(KtExpression expression) {
        PsiElement psiElement;
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtLoopExpression) {
            PsiElement psiElement2 = ((KtLoopExpression)expression).getFirstChild();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getFirstChild(...)");
        } else if (ktExpression instanceof KtTryExpression) {
            PsiElement psiElement3 = ((KtTryExpression)expression).getTryKeyword();
            psiElement = psiElement3;
            Intrinsics.checkNotNull(psiElement3);
        } else if (ktExpression instanceof KtIfExpression) {
            PsiElement psiElement4 = ((KtIfExpression)expression).getIfKeyword();
            psiElement = psiElement4;
            Intrinsics.checkNotNullExpressionValue(psiElement4, "getIfKeyword(...)");
        } else if (ktExpression instanceof KtWhenExpression) {
            PsiElement psiElement5 = ((KtWhenExpression)expression).getWhenKeyword();
            psiElement = psiElement5;
            Intrinsics.checkNotNullExpressionValue(psiElement5, "getWhenKeyword(...)");
        } else {
            psiElement = expression;
        }
        return psiElement;
    }

    private final boolean isTernaryOperator(KtExpression tree) {
        if (!(tree instanceof KtIfExpression) || ((KtIfExpression)tree).getElse() == null) {
            return false;
        }
        return !(((KtIfExpression)tree).getThen() instanceof KtBlockExpression) && !(((KtIfExpression)tree).getElse() instanceof KtBlockExpression) && !(((KtIfExpression)tree).getElse() instanceof KtIfExpression);
    }

    private final boolean isElseIfStatement(PsiElement parent2, PsiElement tree) {
        PsiElement p2 = parent2.getParent();
        return tree instanceof KtIfExpression && p2 instanceof KtIfExpression && Intrinsics.areEqual(tree, ((KtIfExpression)p2).getElse());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooDeeplyNestedStatementsCheck$Companion;", "", "<init>", "()V", "DEFAULT_MAX_DEPTH", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

