/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;

@Rule(key="S1067")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0013H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "max", "", "getMax", "()I", "setMax", "(I)V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "isParentExpression", "", "computeExpressionComplexity", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "sonar-kotlin-checks"})
public final class TooComplexExpressionCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="max", description="Maximum number of allowed conditional operators in an expression", defaultValue="3")
    private int max = 3;
    private static final int DEFAULT_MAX_COMPLEXITY = 3;

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n2) {
        this.max = n2;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression expression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.isParentExpression(expression)) {
            return;
        }
        int complexity = this.computeExpressionComplexity(expression);
        if (complexity > this.max) {
            AbstractCheck.reportIssue$default((AbstractCheck)this, kotlinFileContext, (PsiElement)expression, "Reduce the number of conditional operators (" + complexity + ") used in the expression (maximum allowed " + this.max + ").", null, (Double)((double)complexity - (double)this.max), 4, null);
        }
    }

    private final boolean isParentExpression(KtBinaryExpression expression) {
        Iterator<PsiElement> iterator2 = PsiUtilsKt.getParents(expression).iterator();
        while (iterator2.hasNext()) {
            PsiElement parent2 = iterator2.next();
            if (parent2 instanceof KtBinaryExpression) {
                return false;
            }
            if (parent2 instanceof KtUnaryExpression && parent2 instanceof KtParenthesizedExpression) continue;
            return true;
        }
        return true;
    }

    private final int computeExpressionComplexity(KtExpression expression) {
        int n2;
        KtExpression e2 = this.skipParentheses(expression);
        if (e2 instanceof KtBinaryExpression) {
            KtSingleValueToken operator = ((KtBinaryExpression)e2).getOperationReference().getOperationSignTokenType();
            int complexity = Intrinsics.areEqual(operator, KtTokens.OROR) || Intrinsics.areEqual(operator, KtTokens.ANDAND) ? 1 : 0;
            KtExpression ktExpression = ((KtBinaryExpression)e2).getLeft();
            Intrinsics.checkNotNull(ktExpression);
            int n3 = complexity + this.computeExpressionComplexity(ktExpression);
            KtExpression ktExpression2 = ((KtBinaryExpression)e2).getRight();
            Intrinsics.checkNotNull(ktExpression2);
            n2 = n3 + this.computeExpressionComplexity(ktExpression2);
        } else if (e2 instanceof KtUnaryExpression) {
            KtExpression ktExpression = ((KtUnaryExpression)e2).getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            n2 = this.computeExpressionComplexity(ktExpression);
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/sonarsource/kotlin/checks/TooComplexExpressionCheck$Companion;", "", "<init>", "()V", "DEFAULT_MAX_COMPLEXITY", "", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

