/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.checks.TodoCommentCheckKt;

@Rule(key="S1135")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/TodoCommentCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class TodoCommentCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        file.accept(new KtTreeVisitorVoid(kotlinFileContext, this){
            final /* synthetic */ KotlinFileContext $kotlinFileContext;
            final /* synthetic */ TodoCommentCheck this$0;
            {
                this.$kotlinFileContext = $kotlinFileContext;
                this.this$0 = $receiver;
            }

            public void visitElement(PsiElement element) {
                block1: {
                    Intrinsics.checkNotNullParameter(element, "element");
                    super.visitElement(element);
                    if (!(element instanceof PsiComment)) {
                        return;
                    }
                    Regex regex = TodoCommentCheckKt.getTodoPattern();
                    String string = ((PsiComment)element).getText();
                    Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                    MatchResult matchResult = Regex.find$default(regex, string, 0, 2, null);
                    if (matchResult == null) break block1;
                    MatchResult matchResult2 = matchResult;
                    KotlinFileContext kotlinFileContext = this.$kotlinFileContext;
                    TodoCommentCheck todoCommentCheck = this.this$0;
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    int n2 = ((PsiComment)element).getTextOffset();
                    MatchGroup matchGroup = matchResult3.getGroups().get(2);
                    Intrinsics.checkNotNull(matchGroup);
                    int todoOffset = n2 + matchGroup.getRange().getFirst();
                    Document document = kotlinFileContext.getKtFile().getViewProvider().getDocument();
                    Intrinsics.checkNotNull(document);
                    Document document2 = document;
                    InputFile inputFile = kotlinFileContext.getInputFileContext().getInputFile();
                    TextRange todoRange = inputFile.newRange(KotlinTextRanges.INSTANCE.textPointerAtOffset(inputFile, document2, todoOffset), KotlinTextRanges.INSTANCE.textPointerAtOffset(inputFile, document2, todoOffset + 4));
                    AbstractCheck.reportIssue$default((AbstractCheck)todoCommentCheck, kotlinFileContext, todoRange, "Complete the task associated to this TODO comment.", null, null, 12, null);
                }
            }
        });
    }
}

