/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;

@Rule(key="S1192")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "check", "", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "occurrencesMap", "", "", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectStringTemplatesNotInAnnotations", "Lkotlin/sequences/Sequence;", "node", "Lcom/intellij/psi/PsiElement;", "Companion", "sonar-kotlin-checks"})
public final class StringLiteralDuplicatedCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    private int threshold = 3;
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 5;
    @NotNull
    private static final Regex NO_SEPARATOR_REGEXP = new Regex("\\w++");

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n2) {
        this.threshold = n2;
    }

    private final void check(KotlinFileContext context, Map<String, ? extends List<? extends KtStringTemplateExpression>> occurrencesMap) {
        Iterator<Map.Entry<String, ? extends List<? extends KtStringTemplateExpression>>> iterator2 = occurrencesMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<? extends KtStringTemplateExpression> occurrences = iterator2.next().getValue();
            int size = occurrences.size();
            if (size < this.threshold) continue;
            KtStringTemplateExpression first2 = occurrences.get(0);
            this.reportIssue(context, (PsiElement)first2, "Define a constant instead of duplicating this literal \"" + ApiExtensionsKt.asString(first2) + "\" " + size + " times.", SequencesKt.toList(SequencesKt.map(SequencesKt.drop(CollectionsKt.asSequence((Iterable)occurrences), 1), arg_0 -> StringLiteralDuplicatedCheck.check$lambda$0(context, arg_0))), (Double)((double)size - 1.0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file, @NotNull KotlinFileContext context) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(context, "context");
        Sequence<Pair> sequence2 = SequencesKt.filter(SequencesKt.map(this.collectStringTemplatesNotInAnnotations(file), StringLiteralDuplicatedCheck::visitKtFile$lambda$1), StringLiteralDuplicatedCheck::visitKtFile$lambda$2);
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            String text;
            Pair pair = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-StringLiteralDuplicatedCheck$visitKtFile$occurrences$52 = false;
            String key$iv$iv = text = (String)pair.component2();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-StringLiteralDuplicatedCheck$visitKtFile$occurrences$52 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((KtStringTemplateExpression)it.getFirst());
        }
        Map occurrences = destination$iv$iv;
        this.check(context, occurrences);
    }

    private final Sequence<KtStringTemplateExpression> collectStringTemplatesNotInAnnotations(PsiElement node) {
        Sequence<Object> sequence2;
        if (node instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)node).hasInterpolation()) {
            sequence2 = SequencesKt.sequenceOf(node);
        } else if (node instanceof KtAnnotationEntry) {
            sequence2 = SequencesKt.emptySequence();
        } else {
            PsiElement[] psiElementArray = node.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            sequence2 = SequencesKt.flatMap(ArraysKt.asSequence((Object[])psiElementArray), arg_0 -> StringLiteralDuplicatedCheck.collectStringTemplatesNotInAnnotations$lambda$5(this, arg_0));
        }
        return sequence2;
    }

    private static final SecondaryLocation check$lambda$0(KotlinFileContext $context, KtStringTemplateExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange($context, it), "Duplication");
    }

    private static final Pair visitKtFile$lambda$1(KtStringTemplateExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it, ApiExtensionsKt.asString(it));
    }

    private static final boolean visitKtFile$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter(pair, "<destruct>");
        String text = (String)pair.component2();
        return text.length() > 5 && !NO_SEPARATOR_REGEXP.matches(text);
    }

    private static final Sequence collectStringTemplatesNotInAnnotations$lambda$5(StringLiteralDuplicatedCheck this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.collectStringTemplatesNotInAnnotations(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/StringLiteralDuplicatedCheck$Companion;", "", "<init>", "()V", "DEFAULT_THRESHOLD", "", "MINIMAL_LITERAL_LENGTH", "NO_SEPARATOR_REGEXP", "Lkotlin/text/Regex;", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

