/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.SingleConstructorCallExtractor;
import org.sonarsource.kotlin.checks.SingletonClassCandidateExtractor;
import org.sonarsource.kotlin.checks.SingletonPatternCheckKt;

@Rule(key="S6515")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/sonarsource/kotlin/checks/SingletonPatternCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
public final class SingletonPatternCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        SingletonClassCandidateExtractor singletonClassCandidateExtractor = new SingletonClassCandidateExtractor();
        singletonClassCandidateExtractor.visitTree(file);
        Set<String> singletonClassCandidates = singletonClassCandidateExtractor.getSingletonClassCandidates();
        if (singletonClassCandidates.isEmpty()) {
            return;
        }
        SingleConstructorCallExtractor singleConstructorCallExtractor = new SingleConstructorCallExtractor(singletonClassCandidates);
        singleConstructorCallExtractor.visitTree(file);
        Map<String, KtCallExpression> singleConstructorCallByClass = singleConstructorCallExtractor.getSingleConstructorCallByClass();
        if (singleConstructorCallByClass.isEmpty()) {
            return;
        }
        singleConstructorCallByClass.values().stream().filter(arg_0 -> SingletonPatternCheck.visitKtFile$lambda$1(SingletonPatternCheck::visitKtFile$lambda$0, arg_0)).forEach(arg_0 -> SingletonPatternCheck.visitKtFile$lambda$3(arg_0 -> SingletonPatternCheck.visitKtFile$lambda$2(this, kotlinFileContext, arg_0), arg_0));
    }

    private static final boolean visitKtFile$lambda$0(KtCallExpression it) {
        Intrinsics.checkNotNull(it);
        return SingletonPatternCheckKt.access$isInitializingCall(it) || SingletonPatternCheckKt.access$isLazyInitializingCall(it);
    }

    private static final boolean visitKtFile$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit visitKtFile$lambda$2(SingletonPatternCheck this$0, KotlinFileContext $kotlinFileContext, KtCallExpression it) {
        AbstractCheck abstractCheck = this$0;
        Intrinsics.checkNotNull(it);
        AbstractCheck.reportIssue$default(abstractCheck, $kotlinFileContext, (PsiElement)it, "Singleton pattern should use object declarations or expressions.", null, null, 12, null);
        return Unit.INSTANCE;
    }

    private static final void visitKtFile$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

