/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sonarsource.kotlin.api.checks.ArgumentMatcher;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u001a\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"ASYMMETRIC_INITIALIZE_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "ASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER", "ASYMMETRIC_ALGORITHMS", "", "", "ASYMMETRIC_MIN_KEY_SIZE", "", "SYMMETRIC_INIT_MATCHER", "SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER", "SYMMETRIC_ALGORITHMS", "SYMMETRIC_MIN_KEY_SIZE", "EC_GEN_PARAMETER_SPEC_MATCHER", "INSECURE_EC_SPECS", "EC_MIN_KEY_SIZE", "msg", "minKeySize", "algorithm", "sonar-kotlin-checks"})
public final class RobustCryptographicKeysCheckKt {
    @NotNull
    private static final FunMatcherImpl ASYMMETRIC_INITIALIZE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RobustCryptographicKeysCheckKt::ASYMMETRIC_INITIALIZE_MATCHER$lambda$0, 1023, null);
    @NotNull
    private static final FunMatcherImpl ASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RobustCryptographicKeysCheckKt::ASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$lambda$1, 1023, null);
    @NotNull
    private static final Set<String> ASYMMETRIC_ALGORITHMS;
    private static final int ASYMMETRIC_MIN_KEY_SIZE = 2048;
    @NotNull
    private static final FunMatcherImpl SYMMETRIC_INIT_MATCHER;
    @NotNull
    private static final FunMatcherImpl SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER;
    @NotNull
    private static final Set<String> SYMMETRIC_ALGORITHMS;
    private static final int SYMMETRIC_MIN_KEY_SIZE = 128;
    @NotNull
    private static final FunMatcherImpl EC_GEN_PARAMETER_SPEC_MATCHER;
    @NotNull
    private static final Set<String> INSECURE_EC_SPECS;
    private static final int EC_MIN_KEY_SIZE = 224;

    private static final String msg(int minKeySize, String algorithm) {
        return "Use a key length of at least " + minKeySize + " bits for " + algorithm + " cipher algorithm.";
    }

    private static final Unit ASYMMETRIC_INITIALIZE_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("java.security.KeyPairGenerator");
        Object[] objectArray = new String[]{"initialize"};
        $this$FunMatcher.withNames((String[])objectArray);
        objectArray = new String[]{"kotlin.Int"};
        $this$FunMatcher.withArguments((String[])objectArray);
        objectArray = new ArgumentMatcher[]{new ArgumentMatcher("kotlin.Int", null, false, false, 14, null), ArgumentMatcher.Companion.getANY()};
        $this$FunMatcher.withArguments((ArgumentMatcher[])objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit ASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("java.security.KeyPairGenerator");
        String[] stringArray = new String[]{"getInstance"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit SYMMETRIC_INIT_MATCHER$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.crypto.KeyGenerator");
        Object[] objectArray = new String[]{"init"};
        $this$FunMatcher.withNames((String[])objectArray);
        objectArray = new String[]{"kotlin.Int"};
        $this$FunMatcher.withArguments((String[])objectArray);
        objectArray = new ArgumentMatcher[]{new ArgumentMatcher("kotlin.Int", null, false, false, 14, null), ArgumentMatcher.Companion.getANY()};
        $this$FunMatcher.withArguments((ArgumentMatcher[])objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setQualifier("javax.crypto.KeyGenerator");
        String[] stringArray = new String[]{"getInstance"};
        $this$FunMatcher.withNames(stringArray);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FunMatcherImpl access$getASYMMETRIC_INITIALIZE_MATCHER$p() {
        return ASYMMETRIC_INITIALIZE_MATCHER;
    }

    public static final /* synthetic */ Set access$getASYMMETRIC_ALGORITHMS$p() {
        return ASYMMETRIC_ALGORITHMS;
    }

    public static final /* synthetic */ FunMatcherImpl access$getASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p() {
        return ASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getSYMMETRIC_INIT_MATCHER$p() {
        return SYMMETRIC_INIT_MATCHER;
    }

    public static final /* synthetic */ Set access$getSYMMETRIC_ALGORITHMS$p() {
        return SYMMETRIC_ALGORITHMS;
    }

    public static final /* synthetic */ FunMatcherImpl access$getSYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p() {
        return SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getEC_GEN_PARAMETER_SPEC_MATCHER$p() {
        return EC_GEN_PARAMETER_SPEC_MATCHER;
    }

    public static final /* synthetic */ Set access$getINSECURE_EC_SPECS$p() {
        return INSECURE_EC_SPECS;
    }

    public static final /* synthetic */ String access$msg(int minKeySize, String algorithm) {
        return RobustCryptographicKeysCheckKt.msg(minKeySize, algorithm);
    }

    static {
        String[] stringArray = new String[]{"dsa", "rsa", "dh", "diffiehellman"};
        ASYMMETRIC_ALGORITHMS = SetsKt.setOf(stringArray);
        SYMMETRIC_INIT_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RobustCryptographicKeysCheckKt::SYMMETRIC_INIT_MATCHER$lambda$2, 1023, null);
        SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RobustCryptographicKeysCheckKt::SYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$lambda$3, 1023, null);
        SYMMETRIC_ALGORITHMS = SetsKt.setOf("aes");
        EC_GEN_PARAMETER_SPEC_MATCHER = FunMatcherKt.ConstructorMatcher$default("java.security.spec.ECGenParameterSpec", null, 2, null);
        stringArray = new String[]{"secp112r1", "secp112r2", "secp128r1", "secp128r2", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "prime192v2", "prime192v3", "sect113r1", "sect113r2", "sect131r1", "sect131r2", "sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "c2tnb191v1", "c2tnb191v2", "c2tnb191v3"};
        INSECURE_EC_SPECS = SetsKt.setOf(stringArray);
    }
}

