/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.RobustCryptographicKeysCheckKt;

@Rule(key="S4426")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002JB\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/sonarsource/kotlin/checks/RobustCryptographicKeysCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitCallExpression", "", "callExpr", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)Lkotlin/Unit;", "handleECGenParameterSpec", "handleKeyGeneratorAndKeyPairGenerator", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "minKeySize", "", "unsafeAlgorithms", "", "", "getInstanceMatcher", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "sonar-kotlin-checks"})
public final class RobustCryptographicKeysCheck
extends AbstractCheck {
    @Override
    @Nullable
    public Unit visitCallExpression(@NotNull KtCallExpression callExpr, @NotNull KotlinFileContext context) {
        Unit unit;
        Intrinsics.checkNotNullParameter(callExpr, "callExpr");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$visitCallExpression_u24lambda_u241 = kaSession;
        boolean bl = false;
        KaLifetimeOwner kaLifetimeOwner = $this$visitCallExpression_u24lambda_u241.resolveToCall(callExpr);
        if (kaLifetimeOwner != null && (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull(kaLifetimeOwner)) != null) {
            KaLifetimeOwner resolvedCall2 = kaLifetimeOwner;
            boolean bl2 = false;
            if (FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, RobustCryptographicKeysCheckKt.access$getASYMMETRIC_INITIALIZE_MATCHER$p())) {
                this.handleKeyGeneratorAndKeyPairGenerator(callExpr, (KaFunctionCall<?>)resolvedCall2, 2048, RobustCryptographicKeysCheckKt.access$getASYMMETRIC_ALGORITHMS$p(), RobustCryptographicKeysCheckKt.access$getASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p(), context);
            } else if (FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, RobustCryptographicKeysCheckKt.access$getSYMMETRIC_INIT_MATCHER$p())) {
                this.handleKeyGeneratorAndKeyPairGenerator(callExpr, (KaFunctionCall<?>)resolvedCall2, 128, RobustCryptographicKeysCheckKt.access$getSYMMETRIC_ALGORITHMS$p(), RobustCryptographicKeysCheckKt.access$getSYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p(), context);
            } else if (FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, RobustCryptographicKeysCheckKt.access$getEC_GEN_PARAMETER_SPEC_MATCHER$p())) {
                this.handleECGenParameterSpec(callExpr, context);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void handleECGenParameterSpec(KtCallExpression callExpr, KotlinFileContext context) {
        block3: {
            String string;
            KtExpression ktExpression = callExpr.getValueArguments().get(0).getArgumentExpression();
            if (ktExpression == null) break block3;
            KtExpression specArgExpr = ktExpression;
            boolean bl = false;
            Iterable iterable = RobustCryptographicKeysCheckKt.access$getINSECURE_EC_SPECS$p();
            String string2 = ApiExtensionsKt.predictRuntimeStringValue(specArgExpr);
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            } else {
                string = null;
            }
            if (CollectionsKt.contains(iterable, string)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)specArgExpr, RobustCryptographicKeysCheckKt.access$msg(224, "EC"), null, null, 12, null);
            }
        }
    }

    private final void handleKeyGeneratorAndKeyPairGenerator(KtCallExpression callExpr, KaFunctionCall<?> resolvedCall2, int minKeySize, Collection<String> unsafeAlgorithms, FunMatcherImpl getInstanceMatcher, KotlinFileContext context) {
        block5: {
            boolean $i$f$withKaSession = false;
            KaSession kaSession = KotlinFileVisitorKt.getKaSession();
            Intrinsics.checkNotNull(kaSession);
            KaSession $this$handleKeyGeneratorAndKeyPairGenerator_u24lambda_u244 = kaSession;
            boolean bl = false;
            KtExpression ktExpression = ApiExtensionsKt.getFirstArgumentExpression(resolvedCall2);
            if (ktExpression == null) {
                return;
            }
            KtExpression keySizeExpression = ktExpression;
            Integer keySize = ApiExtensionsKt.predictRuntimeIntValue(keySizeExpression);
            if (keySize == null || keySize >= minKeySize) break block5;
            Object object = ApiExtensionsKt.predictReceiverExpression(callExpr);
            if (object == null || (object = $this$handleKeyGeneratorAndKeyPairGenerator_u24lambda_u244.resolveToCall((KtElement)object)) == null || (object = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)object)) == null) {
                return;
            }
            Object getInstanceCall = object;
            if (getInstanceMatcher.matches((KaCallableMemberCall)getInstanceCall)) {
                KtExpression algoExpr = ApiExtensionsKt.getFirstArgumentExpression(getInstanceCall);
                Object object2 = algoExpr;
                if (object2 != null && (object2 = ApiExtensionsKt.predictRuntimeStringValue((KtExpression)object2)) != null) {
                    Object algo = object2;
                    boolean bl2 = false;
                    String string = ((String)algo).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    if (unsafeAlgorithms.contains(string)) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to(algoExpr, "Using " + (String)algo + " cipher algorithm")};
                        AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)keySizeExpression, RobustCryptographicKeysCheckKt.access$msg(minKeySize, (String)algo), this.locationListOf(context, pairArray), null, 8, null);
                    }
                }
            }
        }
    }
}

