/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt$equalsHasDefaultImpl$;
import org.sonarsource.kotlin.checks.RedundantMethodsInDataClassesCheckKt$hashCodeHasDefaultImpl$;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a \u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a2\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a8\u0010\u0013\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001aL\u0010\u0014\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001aL\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0016H\u0002\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a(\u0010\u001c\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"EQUALS_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "HASHCODE_MATCHER", "OBJECTS_HASH_MATCHER", "ARRAYS_HASHCODE_MATCHER", "hashCodeHasDefaultImpl", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "klassParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "checkHashExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "equalsHasDefaultImpl", "methodParameters", "", "className", "", "checkEqualsExpression", "visitExpression", "map", "", "checkIfExpressionHasParameter", "", "first", "second", "findParameter", "checkDotExpression", "klassParameter", "sonar-kotlin-checks"})
public final class RedundantMethodsInDataClassesCheckKt {
    @NotNull
    private static final FunMatcherImpl EQUALS_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RedundantMethodsInDataClassesCheckKt::EQUALS_MATCHER$lambda$0, 1023, null);
    @NotNull
    private static final FunMatcherImpl HASHCODE_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, RedundantMethodsInDataClassesCheckKt::HASHCODE_MATCHER$lambda$1, 1023, null);
    @NotNull
    private static final FunMatcherImpl OBJECTS_HASH_MATCHER = FunMatcherKt.FunMatcher$default("java.util.Objects", "hash", null, null, false, null, null, null, null, null, null, 2044, null);
    @NotNull
    private static final FunMatcherImpl ARRAYS_HASHCODE_MATCHER = FunMatcherKt.FunMatcher$default("java.util.Arrays", "hashCode", null, null, false, null, null, null, null, null, null, 2044, null);

    /*
     * WARNING - void declaration
     */
    private static final boolean hashCodeHasDefaultImpl(KtNamedFunction $this$hashCodeHasDefaultImpl, List<? extends KtParameter> klassParameters) {
        boolean bl;
        if ($this$hashCodeHasDefaultImpl.hasBlockBody()) {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType_u24default$iv = $this$hashCodeHasDefaultImpl;
            Function1 predicate$iv = hashCodeHasDefaultImpl$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var11_10 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            List returnExpressions = (List)to$iv$iv$iv;
            if (returnExpressions.size() > 1) {
                return false;
            }
            bl = RedundantMethodsInDataClassesCheckKt.checkHashExpression(((KtReturnExpression)returnExpressions.get(0)).getReturnedExpression(), klassParameters);
        } else {
            bl = RedundantMethodsInDataClassesCheckKt.checkHashExpression($this$hashCodeHasDefaultImpl.getBodyExpression(), klassParameters);
        }
        return bl;
    }

    private static final boolean checkHashExpression(KtExpression expression, List<? extends KtParameter> klassParameters) {
        if (!(expression instanceof KtDotQualifiedExpression)) {
            return false;
        }
        if (!(((KtDotQualifiedExpression)expression).getSelectorExpression() instanceof KtCallExpression)) {
            return false;
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression).getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
        KtCallExpression callExpression = (KtCallExpression)ktExpression;
        if (OBJECTS_HASH_MATCHER.matches(callExpression)) {
            boolean bl;
            block13: {
                if (callExpression.getValueArguments().size() != klassParameters.size()) {
                    return false;
                }
                List<KtValueArgument> list = callExpression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl2 = false;
                        if (RedundantMethodsInDataClassesCheckKt.findParameter(it.getArgumentExpression(), klassParameters) != null) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        if (ARRAYS_HASHCODE_MATCHER.matches(callExpression)) {
            boolean bl;
            block14: {
                KtExpression argumentExpression = callExpression.getValueArguments().get(0).getArgumentExpression();
                if (!(argumentExpression instanceof KtCallExpression)) {
                    return false;
                }
                List<KtValueArgument> list = ((KtCallExpression)argumentExpression).getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                List<KtValueArgument> arguments2 = list;
                if (arguments2.size() != klassParameters.size()) {
                    return false;
                }
                Iterable $this$all$iv = arguments2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        boolean bl3 = false;
                        if (RedundantMethodsInDataClassesCheckKt.findParameter(it.getArgumentExpression(), klassParameters) != null) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean equalsHasDefaultImpl(KtNamedFunction $this$equalsHasDefaultImpl, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, String className) {
        boolean bl;
        if ($this$equalsHasDefaultImpl.hasBlockBody()) {
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType_u24default$iv = $this$equalsHasDefaultImpl;
            Function1 predicate$iv = equalsHasDefaultImpl$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var13_12 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtReturnExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            List returnExpressions = (List)to$iv$iv$iv;
            if (returnExpressions.size() > 1) {
                return false;
            }
            bl = RedundantMethodsInDataClassesCheckKt.checkEqualsExpression(((KtReturnExpression)returnExpressions.get(0)).getReturnedExpression(), klassParameters, methodParameters, className);
        } else {
            bl = RedundantMethodsInDataClassesCheckKt.checkEqualsExpression($this$equalsHasDefaultImpl.getBodyExpression(), klassParameters, methodParameters, className);
        }
        return bl;
    }

    private static final boolean checkEqualsExpression(KtExpression expression, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, String className) {
        Map map2 = new LinkedHashMap();
        Iterable $this$forEach$iv = klassParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            map2.put(it, false);
        }
        return RedundantMethodsInDataClassesCheckKt.visitExpression(expression, klassParameters, methodParameters, map2, className) && !map2.values().contains(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean visitExpression(KtExpression expression, List<? extends KtParameter> klassParameters, List<KtParameter> methodParameters, Map<KtParameter, Boolean> map2, String className) {
        if (expression instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual(((KtBinaryExpression)expression).getOperationToken(), KtTokens.ANDAND)) {
                if (!RedundantMethodsInDataClassesCheckKt.visitExpression(((KtBinaryExpression)expression).getRight(), klassParameters, methodParameters, map2, className)) return false;
                if (!RedundantMethodsInDataClassesCheckKt.visitExpression(((KtBinaryExpression)expression).getLeft(), klassParameters, methodParameters, map2, className)) return false;
                return true;
            }
            if (Intrinsics.areEqual(((KtBinaryExpression)expression).getOperationToken(), KtTokens.EQEQ)) {
                RedundantMethodsInDataClassesCheckKt.checkIfExpressionHasParameter(((KtBinaryExpression)expression).getLeft(), ((KtBinaryExpression)expression).getRight(), klassParameters, methodParameters, map2);
                RedundantMethodsInDataClassesCheckKt.checkIfExpressionHasParameter(((KtBinaryExpression)expression).getRight(), ((KtBinaryExpression)expression).getLeft(), klassParameters, methodParameters, map2);
                return true;
            }
        }
        if (!(expression instanceof KtIsExpression)) return false;
        if (((KtIsExpression)expression).isNegated()) return false;
        KtTypeReference ktTypeReference = ((KtIsExpression)expression).getTypeReference();
        if (!Intrinsics.areEqual(ktTypeReference != null ? ktTypeReference.nameForReceiverLabel() : null, className)) return false;
        return true;
    }

    private static final void checkIfExpressionHasParameter(KtExpression first2, KtExpression second2, List<? extends KtParameter> klassParameters, List<? extends KtParameter> methodParameters, Map<KtParameter, Boolean> map2) {
        KtParameter ktParameter = RedundantMethodsInDataClassesCheckKt.findParameter(first2, klassParameters);
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        if (RedundantMethodsInDataClassesCheckKt.checkDotExpression(second2, parameter, methodParameters)) {
            map2.put(parameter, true);
        }
    }

    private static final KtParameter findParameter(KtExpression expression, List<? extends KtParameter> klassParameters) {
        KtParameter ktParameter;
        if (expression instanceof KtNameReferenceExpression) {
            Object v0;
            block3: {
                Iterable iterable = klassParameters;
                for (Object t2 : iterable) {
                    KtParameter klassParameter = (KtParameter)t2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(klassParameter.getName(), ((KtNameReferenceExpression)expression).getReferencedName())) continue;
                    v0 = t2;
                    break block3;
                }
                v0 = null;
            }
            ktParameter = v0;
        } else {
            ktParameter = null;
        }
        return ktParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkDotExpression(KtExpression expression, KtParameter klassParameter, List<? extends KtParameter> methodParameters) {
        if (!(expression instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression).getReceiverExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        if (!Intrinsics.areEqual(((KtNameReferenceExpression)ktExpression).getReferencedName(), methodParameters.get(0).getName())) return false;
        KtExpression ktExpression2 = ((KtDotQualifiedExpression)expression).getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        if (!Intrinsics.areEqual(((KtNameReferenceExpression)ktExpression2).getReferencedName(), klassParameter.getName())) return false;
        return true;
    }

    private static final Unit EQUALS_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setName("equals");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        $this$FunMatcher.setReturnType("kotlin.Boolean");
        return Unit.INSTANCE;
    }

    private static final Unit HASHCODE_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setName("hashCode");
        $this$FunMatcher.withNoArguments();
        $this$FunMatcher.setReturnType("kotlin.Int");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FunMatcherImpl access$getEQUALS_MATCHER$p() {
        return EQUALS_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getHASHCODE_MATCHER$p() {
        return HASHCODE_MATCHER;
    }

    public static final /* synthetic */ boolean access$equalsHasDefaultImpl(KtNamedFunction $receiver, List klassParameters, List methodParameters, String className) {
        return RedundantMethodsInDataClassesCheckKt.equalsHasDefaultImpl($receiver, klassParameters, methodParameters, className);
    }

    public static final /* synthetic */ boolean access$hashCodeHasDefaultImpl(KtNamedFunction $receiver, List klassParameters) {
        return RedundantMethodsInDataClassesCheckKt.hashCodeHasDefaultImpl($receiver, klassParameters);
    }
}

