/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"MESSAGE", "", "MATH_RANDOM_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "KOTLIN_RANDOM_MATCHER", "LANG3_RANDOM_STRING_UTILS", "RANDOM_TYPES_MATCHER", "RANDOM_STRING_UTILS_SECURE_INSTANCES", "RANDOM_CONSTRUCTORS_MATCHER", "isChainedMethodInvocation", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "sonar-kotlin-checks"})
public final class PseudoRandomCheckKt {
    @NotNull
    private static final String MESSAGE = "Make sure that using this pseudorandom number generator is safe here.";
    @NotNull
    private static final FunMatcherImpl MATH_RANDOM_MATCHER = FunMatcherKt.FunMatcher$default("java.lang.Math", "random", null, null, false, null, null, null, null, null, PseudoRandomCheckKt::MATH_RANDOM_MATCHER$lambda$0, 1020, null);
    @NotNull
    private static final FunMatcherImpl KOTLIN_RANDOM_MATCHER = FunMatcherKt.FunMatcher$default("kotlin.random", "Random", null, null, false, null, null, null, null, null, null, 2044, null);
    @NotNull
    private static final String LANG3_RANDOM_STRING_UTILS = "org.apache.commons.lang3.RandomStringUtils";
    @NotNull
    private static final FunMatcherImpl RANDOM_TYPES_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, PseudoRandomCheckKt::RANDOM_TYPES_MATCHER$lambda$1, 1023, null);
    @NotNull
    private static final FunMatcherImpl RANDOM_STRING_UTILS_SECURE_INSTANCES = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, PseudoRandomCheckKt::RANDOM_STRING_UTILS_SECURE_INSTANCES$lambda$2, 1023, null);
    @NotNull
    private static final FunMatcherImpl RANDOM_CONSTRUCTORS_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, true, null, null, null, null, null, PseudoRandomCheckKt::RANDOM_CONSTRUCTORS_MATCHER$lambda$3, 1007, null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isChainedMethodInvocation(KtCallExpression $this$isChainedMethodInvocation) {
        PsiElement psiElement = $this$isChainedMethodInvocation.getParent();
        if (psiElement == null) return false;
        PsiElement it = psiElement;
        boolean bl = false;
        if (!(it instanceof KtDotQualifiedExpression)) return false;
        if (!(((KtDotQualifiedExpression)it).getReceiverExpression() instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)it).getReceiverExpression();
        Intrinsics.checkNotNull(ktExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        if (!(((KtDotQualifiedExpression)ktExpression).getSelectorExpression() instanceof KtCallExpression)) return false;
        return true;
    }

    private static final Unit MATH_RANDOM_MATCHER$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.withNoArguments();
        return Unit.INSTANCE;
    }

    private static final Unit RANDOM_TYPES_MATCHER$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"java.util.concurrent.ThreadLocalRandom", "org.apache.commons.lang.math.RandomUtils", "org.apache.commons.lang3.RandomUtils", "org.apache.commons.lang.RandomStringUtils", "org.apache.commons.lang3.RandomStringUtils"};
        $this$FunMatcher.setQualifiers(SetsKt.setOf(stringArray));
        return Unit.INSTANCE;
    }

    private static final Unit RANDOM_STRING_UTILS_SECURE_INSTANCES$lambda$2(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        $this$FunMatcher.setDefiningSupertypes(SetsKt.setOf(LANG3_RANDOM_STRING_UTILS));
        String[] stringArray = new String[]{"secure", "secureStrong"};
        $this$FunMatcher.setNames(SetsKt.setOf(stringArray));
        return Unit.INSTANCE;
    }

    private static final Unit RANDOM_CONSTRUCTORS_MATCHER$lambda$3(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"java.util.Random", "org.apache.commons.lang.math.JVMRandom"};
        $this$FunMatcher.setQualifiers(SetsKt.setOf(stringArray));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FunMatcherImpl access$getMATH_RANDOM_MATCHER$p() {
        return MATH_RANDOM_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getKOTLIN_RANDOM_MATCHER$p() {
        return KOTLIN_RANDOM_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getRANDOM_TYPES_MATCHER$p() {
        return RANDOM_TYPES_MATCHER;
    }

    public static final /* synthetic */ FunMatcherImpl access$getRANDOM_CONSTRUCTORS_MATCHER$p() {
        return RANDOM_CONSTRUCTORS_MATCHER;
    }

    public static final /* synthetic */ boolean access$isChainedMethodInvocation(KtCallExpression $receiver) {
        return PseudoRandomCheckKt.isChainedMethodInvocation($receiver);
    }

    public static final /* synthetic */ FunMatcherImpl access$getRANDOM_STRING_UTILS_SECURE_INSTANCES$p() {
        return RANDOM_STRING_UTILS_SECURE_INSTANCES;
    }
}

