/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.MainSafeCoroutinesCheckKt;

@Rule(key="S6307")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/sonarsource/kotlin/checks/MainSafeCoroutinesCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "<init>", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "reportBlockingFunctionCalls", "Lorg/jetbrains/kotlin/psi/KtElement;", "sonar-kotlin-checks"})
public final class MainSafeCoroutinesCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement suspendModifier = ApiExtensionsKt.suspendModifier(function2);
        if (suspendModifier != null) {
            this.reportBlockingFunctionCalls(function2, context);
        } else {
            void $this$forEachDescendantOfType$iv;
            PsiElement psiElement = function2;
            Function1<KtLambdaArgument, Unit> action$iv = arg_0 -> MainSafeCoroutinesCheck.visitNamedFunction$lambda$0(this, context, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtLambdaArgument) {
                        this.$action.invoke(element);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportBlockingFunctionCalls(KtElement $this$reportBlockingFunctionCalls, KotlinFileContext context) {
        void $this$forEachDescendantOfType$iv;
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$reportBlockingFunctionCalls_u24lambda_u243 = kaSession;
        boolean bl = false;
        PsiElement psiElement = $this$reportBlockingFunctionCalls;
        Function1<KtCallExpression, Unit> action$iv = arg_0 -> MainSafeCoroutinesCheck.reportBlockingFunctionCalls$lambda$3$lambda$2($this$reportBlockingFunctionCalls_u24lambda_u243, this, context, arg_0);
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
        $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtCallExpression) {
                    this.$action.invoke(element);
                }
            }
        });
    }

    private static final Unit visitNamedFunction$lambda$0(MainSafeCoroutinesCheck this$0, KotlinFileContext $context, KtLambdaArgument it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (ApiExtensionsKt.isSuspending(it)) {
            this$0.reportBlockingFunctionCalls(it, $context);
        }
        return Unit.INSTANCE;
    }

    private static final Unit reportBlockingFunctionCalls$lambda$3$lambda$2(KaSession $this_withKaSession, MainSafeCoroutinesCheck this$0, KotlinFileContext $context, KtCallExpression call2) {
        block2: {
            KaFunctionCall<?> resolvedCall2;
            block1: {
                Intrinsics.checkNotNullParameter(call2, "call");
                KaCallInfo kaCallInfo = $this_withKaSession.resolveToCall(call2);
                KaFunctionCall<Object> kaFunctionCall = resolvedCall2 = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
                if (!FunMatcherKt.matches((KaCallableMemberCall)resolvedCall2, MainSafeCoroutinesCheckKt.getTHREAD_SLEEP_MATCHER())) break block1;
                AbstractCheck abstractCheck = this$0;
                KtExpression ktExpression = call2.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression);
                AbstractCheck.reportIssue$default(abstractCheck, $context, (PsiElement)ktExpression, "Replace this \"Thread.sleep()\" call with \"delay()\".", null, null, 12, null);
                break block2;
            }
            KaFunctionCall<?> kaFunctionCall = resolvedCall2;
            if (kaFunctionCall == null || (kaFunctionCall = kaFunctionCall.getPartiallyAppliedSymbol()) == null || (kaFunctionCall = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaFunctionCall)) == null) break block2;
            KaFunctionCall<?> descriptor2 = kaFunctionCall;
            boolean bl = false;
            if (MainSafeCoroutinesCheckKt.access$isInsideNonSafeDispatcher(call2) && ApiExtensionsKt.throwsExceptions(descriptor2, (Collection<String>)MainSafeCoroutinesCheckKt.getBLOCKING_ANNOTATIONS())) {
                AbstractCheck abstractCheck = this$0;
                KtExpression ktExpression = call2.getCalleeExpression();
                Intrinsics.checkNotNull(ktExpression);
                AbstractCheck.reportIssue$default(abstractCheck, $context, (PsiElement)ktExpression, "Use \"Dispatchers.IO\" to run this potentially blocking operation.", null, null, 12, null);
            }
        }
        return Unit.INSTANCE;
    }
}

