/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.CallAbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherBuilderContext;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitorKt;
import org.sonarsource.kotlin.checks.IsInstanceMethodCheckKt;

@Rule(key="S6202")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0012*\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0016*\u00020\u001dH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/sonarsource/kotlin/checks/IsInstanceMethodCheck;", "Lorg/sonarsource/kotlin/api/checks/CallAbstractCheck;", "<init>", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "qualifiedName", "", "Lcom/intellij/psi/PsiElement;", "ctx", "onlyClass", "", "qualifiedNameWithoutJavaClassKeyword", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "isJavaClassKeyword", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isClass", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "sonar-kotlin-checks"})
public final class IsInstanceMethodCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public IsInstanceMethodCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("kotlin.reflect.KClass", "isInstance", null, null, false, null, null, null, null, null, IsInstanceMethodCheck::functionsToVisit$lambda$0, 1020, null), FunMatcherKt.FunMatcher$default("java.lang.Class", "isInstance", null, null, false, null, null, null, null, null, IsInstanceMethodCheck::functionsToVisit$lambda$1, 1020, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull KaFunctionCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block0: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression);
            String string = this.qualifiedName(ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null, kotlinFileContext, true);
            if (string == null) break block0;
            String className = string;
            boolean bl = false;
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Replace this usage of \"isInstance\" with \"is " + className + "\".", null, null, 12, null);
        }
    }

    private final String qualifiedName(PsiElement $this$qualifiedName, KotlinFileContext ctx, boolean onlyClass) {
        Object object;
        KtExpression expr = KtPsiUtil.deparenthesize($this$qualifiedName instanceof KtExpression ? (KtExpression)$this$qualifiedName : null);
        if (expr instanceof KtClassLiteralExpression) {
            object = onlyClass ? this.qualifiedName(((KtClassLiteralExpression)expr).getLhs(), ctx, true) : null;
        } else if (expr instanceof KtNameReferenceExpression) {
            object = !onlyClass || this.isClass((KtReferenceExpression)expr) ? ((KtNameReferenceExpression)expr).getReferencedName() : null;
        } else if (expr instanceof KtDotQualifiedExpression) {
            String right = this.qualifiedName(((KtDotQualifiedExpression)expr).getSelectorExpression(), ctx, onlyClass);
            if (right != null) {
                String string = this.qualifiedName(((KtDotQualifiedExpression)expr).getReceiverExpression(), ctx, false);
                if (string != null) {
                    String left = string;
                    boolean bl = false;
                    object = left + "." + right;
                } else {
                    object = null;
                }
            } else {
                object = this.qualifiedNameWithoutJavaClassKeyword((KtDotQualifiedExpression)expr, ctx, onlyClass);
            }
        } else {
            object = null;
        }
        return object;
    }

    private final String qualifiedNameWithoutJavaClassKeyword(KtDotQualifiedExpression $this$qualifiedNameWithoutJavaClassKeyword, KotlinFileContext ctx, boolean onlyClass) {
        return onlyClass && this.isJavaClassKeyword($this$qualifiedNameWithoutJavaClassKeyword.getSelectorExpression()) ? this.qualifiedName($this$qualifiedNameWithoutJavaClassKeyword.getReceiverExpression(), ctx, true) : null;
    }

    private final boolean isJavaClassKeyword(KtExpression expr) {
        return expr instanceof KtNameReferenceExpression && IsInstanceMethodCheckKt.access$getJAVA_CLASS_KEYWORDS$p().contains(((KtNameReferenceExpression)expr).getReferencedName());
    }

    private final boolean isClass(KtReferenceExpression $this$isClass) {
        boolean $i$f$withKaSession = false;
        KaSession kaSession = KotlinFileVisitorKt.getKaSession();
        Intrinsics.checkNotNull(kaSession);
        KaSession $this$isClass_u24lambda_u244 = kaSession;
        boolean bl = false;
        return $this$isClass_u24lambda_u244.resolveToSymbol(ReferenceUtilsKt.getMainReference($this$isClass)) instanceof KaClassSymbol;
    }

    private static final Unit functionsToVisit$lambda$0(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit functionsToVisit$lambda$1(FunMatcherBuilderContext $this$FunMatcher) {
        Intrinsics.checkNotNullParameter($this$FunMatcher, "$this$FunMatcher");
        String[] stringArray = new String[]{"kotlin.Any"};
        $this$FunMatcher.withArguments(stringArray);
        return Unit.INSTANCE;
    }
}

